/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader.store;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.loader.store.ResourceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceStoreClassLoader
extends ClassLoader {
    private final Log log = LogFactory.getLog(ResourceStoreClassLoader.class);
    private final ResourceStore[] stores;

    public ResourceStoreClassLoader(ClassLoader pParent, ResourceStore[] stores) {
        super(pParent);
        this.stores = stores;
    }

    public ResourceStore[] getStores() {
        return this.stores;
    }

    protected Class<?> fastFindClass(String name) {
        if (this.stores != null) {
            for (ResourceStore store : this.stores) {
                byte[] clazzBytes = store.getBytes(ResourceStoreClassLoader.convertClassToResourcePath(name));
                if (clazzBytes == null) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.getId() + " found class: " + name + " (" + clazzBytes.length + " bytes)"));
                }
                this.doDefinePackage(name);
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
        }
        return null;
    }

    protected void doDefinePackage(String name) {
        String pkgname;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i > -1 && (pkg = this.getPackage(pkgname = name.substring(0, i))) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
    }

    @Override
    protected URL findResource(String name) {
        if (this.stores != null) {
            for (ResourceStore store : this.stores) {
                URL url = store.getURL(name);
                if (url == null) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.getId() + " found resource: " + name));
                }
                return url;
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (this.stores != null) {
            ArrayList<URL> result = new ArrayList<URL>();
            for (ResourceStore store : this.stores) {
                URL url = store.getURL(name);
                if (url == null) continue;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(this.getId() + " found resource: " + name));
                }
                result.add(url);
            }
            return Collections.enumeration(result);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent == null) throw new ClassNotFoundException(name);
                clazz = parent.loadClass(name);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getId() + " loaded from store: " + name));
            }
        }
        if (!resolve) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader parent;
        Enumeration<URL> urls = this.findResources(name);
        if (urls == null && (parent = this.getParent()) != null) {
            urls = parent.getResources(name);
        }
        return urls;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader parent;
        URL url = this.findResource(name);
        if (url == null && (parent = this.getParent()) != null) {
            url = parent.getResource(name);
        }
        return url;
    }

    @Override
    protected Package getPackage(String name) {
        return super.getPackage(name);
    }

    @Override
    protected Package[] getPackages() {
        return super.getPackages();
    }

    protected String getId() {
        return "" + this + "[" + this.getClass().getClassLoader() + "]";
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }
}

