/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.login;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.LoginResponseHandler;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebEngineFormAuthenticator
implements NuxeoAuthenticationPlugin,
LoginResponseHandler {
    private static final Log log = LogFactory.getLog(WebEngineFormAuthenticator.class);
    protected static String usernameKey = "username";
    protected static String passwordKey = "password";
    public static final String LOGIN_KEY = "/@@login";

    public Boolean handleLoginPrompt(HttpServletRequest request, HttpServletResponse response, String baseURL) {
        return false;
    }

    protected String getLoginPathInfo(HttpServletRequest request) {
        String path = request.getRequestURI();
        if (path != null && path.endsWith(LOGIN_KEY)) {
            return path.substring(0, path.length() - LOGIN_KEY.length());
        }
        return null;
    }

    public static boolean isLoginRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        return path != null && path.endsWith(LOGIN_KEY);
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (!WebEngineFormAuthenticator.isLoginRequest(httpRequest)) {
            return null;
        }
        String userName = httpRequest.getParameter(usernameKey);
        String password = httpRequest.getParameter(passwordKey);
        return new UserIdentificationInfo(userName, password);
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return true;
    }

    public void initPlugin(Map<String, String> parameters) {
        if (parameters.get("UsernameKey") != null) {
            usernameKey = parameters.get("UsernameKey");
        }
        if (parameters.get("PasswordKey") != null) {
            passwordKey = parameters.get("PasswordKey");
        }
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return Collections.emptyList();
    }

    public boolean onError(HttpServletRequest request, HttpServletResponse response) {
        try {
            String path = this.getLoginPathInfo(request);
            if (path == null) {
                return false;
            }
            if (request.getParameter("caller") != null) {
                response.sendError(401, "Authentication Failed");
            } else {
                response.setStatus(401);
                response.sendRedirect(path + "?failed=true");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }

    public boolean onSuccess(HttpServletRequest request, HttpServletResponse response) {
        try {
            String path = this.getLoginPathInfo(request);
            if (path == null) {
                return false;
            }
            if (request.getParameter("caller") != null) {
                response.sendError(200);
            } else {
                response.sendRedirect(path);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return false;
        }
        return true;
    }
}

