/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.loader.StaticClassProxy;
import org.nuxeo.ecm.webengine.model.AdapterType;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.impl.AbstractResourceType;
import org.nuxeo.ecm.webengine.model.impl.AdapterDescriptor;
import org.nuxeo.ecm.webengine.model.impl.AdapterTypeImpl;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.ecm.webengine.model.impl.TypeDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.contribution.impl.AbstractContributionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeRegistry
extends AbstractContributionRegistry<String, TypeDescriptor> {
    protected final Map<String, AbstractResourceType> types = new ConcurrentHashMap<String, AbstractResourceType>();
    protected final Map<String, AdapterType> adapters = new ConcurrentHashMap<String, AdapterType>();
    protected final ModuleImpl module;
    protected final WebEngine engine;
    protected ClassProxy docObjectClass;

    public TypeRegistry(TypeRegistry parent, WebEngine engine, ModuleImpl module) {
        super(parent);
        this.module = module;
        this.engine = engine;
        if (parent == null) {
            this.registerRootType();
        } else {
            this.importParentContributions();
        }
    }

    public TypeRegistry(WebEngine engine, ModuleImpl module) {
        this(null, engine, module);
    }

    protected void registerRootType() {
        TypeDescriptor root = new TypeDescriptor(new StaticClassProxy(Resource.class), "*", null);
        this.registerType(root);
    }

    public ResourceType getRootType() {
        return this.types.get("*");
    }

    public ModuleImpl getModule() {
        return this.module;
    }

    public ResourceType getType(String name) {
        ResourceType type = this.types.get(name);
        if (type == null && this.registerDocumentTypeIfNeeded(name)) {
            type = this.types.get(name);
        }
        return type;
    }

    public AdapterType getAdapter(String name) {
        return this.adapters.get(name);
    }

    public AdapterType getAdapter(Resource target, String name) {
        AdapterType adapter = this.adapters.get(name);
        if (adapter != null && adapter.acceptResource(target)) {
            return adapter;
        }
        return null;
    }

    public List<AdapterType> getAdapters(Resource resource) {
        ArrayList<AdapterType> result = new ArrayList<AdapterType>();
        this.collectAdaptersFor(resource, resource.getType(), result);
        return result;
    }

    public List<String> getAdapterNames(Resource resource) {
        ArrayList<String> result = new ArrayList<String>();
        this.collectAdapterNamesFor(resource, resource.getType(), result);
        return result;
    }

    public List<AdapterType> getEnabledAdapters(Resource resource) {
        ArrayList<AdapterType> result = new ArrayList<AdapterType>();
        this.collectEnabledAdaptersFor(resource, resource.getType(), result);
        return result;
    }

    public List<String> getEnabledAdapterNames(Resource resource) {
        ArrayList<String> result = new ArrayList<String>();
        this.collectEnabledAdapterNamesFor(resource, resource.getType(), result);
        return result;
    }

    protected void collectAdaptersFor(Resource ctx, ResourceType type, List<AdapterType> result) {
        for (AdapterType adapter : this.getAdapters()) {
            if (!adapter.acceptResource(ctx)) continue;
            result.add(adapter);
        }
    }

    protected void collectAdapterNamesFor(Resource ctx, ResourceType type, List<String> result) {
        for (AdapterType adapter : this.getAdapters()) {
            if (!adapter.acceptResource(ctx)) continue;
            result.add(adapter.getAdapterName());
        }
    }

    protected void collectEnabledAdaptersFor(Resource ctx, ResourceType type, List<AdapterType> result) {
        for (AdapterType adapter : this.getAdapters()) {
            if (!adapter.acceptResource(ctx) || !adapter.isEnabled(ctx)) continue;
            result.add(adapter);
        }
    }

    protected void collectEnabledAdapterNamesFor(Resource ctx, ResourceType type, List<String> result) {
        for (AdapterType adapter : this.getAdapters()) {
            if (!adapter.acceptResource(ctx) || !adapter.isEnabled(ctx)) continue;
            result.add(adapter.getAdapterName());
        }
    }

    public ResourceType[] getTypes() {
        return this.types.values().toArray(new ResourceType[this.types.size()]);
    }

    public AdapterType[] getAdapters() {
        return this.adapters.values().toArray(new AdapterType[this.adapters.size()]);
    }

    public void registerTypeDescriptor(TypeDescriptor td) {
        if (td.isAdapter()) {
            this.registerAdapter(td.asAdapterDescriptor());
        } else {
            this.registerType(td);
        }
    }

    public synchronized void registerType(TypeDescriptor td) {
        if (td.superType != null && !this.types.containsKey(td.superType)) {
            this.registerDocumentTypeIfNeeded(td.superType);
        }
        this.addFragment(td.type, td, td.superType);
    }

    public synchronized void registerAdapter(AdapterDescriptor td) {
        this.addFragment(td.type, td, td.superType);
    }

    public void unregisterType(TypeDescriptor td) {
        this.removeFragment(td.type, td);
    }

    public void unregisterAdapter(TypeDescriptor td) {
        this.removeFragment(td.type, td);
    }

    protected boolean registerDocumentTypeIfNeeded(String typeName) {
        DocumentType doctype;
        SchemaManager mgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        if (mgr != null && (doctype = mgr.getDocumentType(typeName)) != null) {
            DocumentType superSuperType = (DocumentType)doctype.getSuperType();
            String superSuperTypeName = "*";
            if (superSuperType != null) {
                superSuperTypeName = superSuperType.getName();
            }
            try {
                if (this.docObjectClass == null) {
                    this.docObjectClass = this.engine.getWebLoader().getClassProxy("org.nuxeo.ecm.core.rest.DocumentObject");
                }
                TypeDescriptor superWebType = new TypeDescriptor(this.docObjectClass, typeName, superSuperTypeName);
                this.registerType(superWebType);
                return true;
            }
            catch (ClassNotFoundException e) {
                System.err.println("Cannot find document resource class. Automatic Core Type support will be disabled ");
            }
        }
        return false;
    }

    @Override
    protected TypeDescriptor clone(TypeDescriptor object) {
        return object.clone();
    }

    @Override
    protected void applyFragment(TypeDescriptor object, TypeDescriptor fragment) {
        if (fragment.clazz != null) {
            object.clazz = fragment.clazz;
        }
        if (object.isAdapter()) {
            AdapterDescriptor so = (AdapterDescriptor)object;
            AdapterDescriptor sf = (AdapterDescriptor)fragment;
            if (sf.facets != null && sf.facets.length > 0) {
                ArrayList<String> list = new ArrayList<String>();
                if (so.facets != null && so.facets.length > 0) {
                    list.addAll(Arrays.asList(so.facets));
                }
                list.addAll(Arrays.asList(sf.facets));
            }
            if (sf.targetType != null && !sf.targetType.equals("*")) {
                so.targetType = sf.targetType;
            }
        }
    }

    @Override
    protected void applySuperFragment(TypeDescriptor object, TypeDescriptor superFragment) {
    }

    @Override
    protected void installContribution(String key, TypeDescriptor object) {
        if (object.isAdapter()) {
            this.installAdapterContribution(key, (AdapterDescriptor)object);
        } else {
            this.installTypeContribution(key, object);
        }
    }

    protected void installTypeContribution(String key, TypeDescriptor object) {
        DocumentType doctype;
        SchemaManager mgr;
        ResourceTypeImpl type = new ResourceTypeImpl(this.engine, this.module, null, object.type, object.clazz, object.visibility);
        if (object.superType != null) {
            type.superType = this.types.get(object.superType);
            assert (type.superType != null);
        }
        if ((mgr = (SchemaManager)Framework.getLocalService(SchemaManager.class)) != null && (doctype = mgr.getDocumentType(type.getName())) != null) {
            if (type.facets == null) {
                type.facets = new HashSet<String>();
            }
            type.facets.addAll(doctype.getFacets());
        }
        this.types.put(object.type, type);
    }

    protected void installAdapterContribution(String key, AdapterDescriptor object) {
        AdapterTypeImpl type = new AdapterTypeImpl(this.engine, this.module, null, object.type, object.name, object.clazz, object.visibility);
        if (object.superType != null) {
            type.superType = this.types.get(object.superType);
            assert (type.superType != null);
        }
        this.types.put(object.type, type);
        this.adapters.put(object.name, type);
    }

    @Override
    protected void updateContribution(String key, TypeDescriptor object, TypeDescriptor oldValue) {
        if (object.isAdapter()) {
            this.updateAdapterContribution(key, (AdapterDescriptor)object);
        } else {
            this.updateTypeContribution(key, object);
        }
    }

    protected void updateTypeContribution(String key, TypeDescriptor object) {
        AbstractResourceType t = this.types.get(key);
        if (t == null) {
            throw new IllegalStateException("Updating an object type which is not registered.");
        }
        t.clazz = object.clazz;
        t.loadAnnotations(this.engine.getAnnotationManager());
        t.flushCache();
    }

    protected void updateAdapterContribution(String key, AdapterDescriptor object) {
        AbstractResourceType t = this.types.get(key);
        if (!(t instanceof AdapterTypeImpl)) {
            throw new IllegalStateException("Updating an adapter type which is not registered: " + key);
        }
        AdapterTypeImpl adapter = (AdapterTypeImpl)t;
        adapter.clazz = object.clazz;
        adapter.loadAnnotations(this.engine.getAnnotationManager());
        t.flushCache();
    }

    @Override
    protected void uninstallContribution(String key, TypeDescriptor value) {
        AbstractResourceType t = this.types.remove(key);
        if (t instanceof AdapterTypeImpl) {
            this.adapters.remove(((AdapterTypeImpl)t).name);
        }
    }

    @Override
    protected boolean isMainFragment(TypeDescriptor object) {
        return object.isMainFragment();
    }
}

