/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.view;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateView {
    protected URL url;
    protected WebContext ctx;
    protected Object target;
    protected Map<String, Object> bindings;

    public TemplateView(Object owner, String name) {
        this(WebEngine.getActiveContext(), owner, name);
    }

    public TemplateView(WebContext ctx, Object owner, String name) {
        if (ctx == null) {
            throw new WebException("Not in WebEngine context");
        }
        this.ctx = ctx;
        this.url = owner.getClass().getResource(name);
        if (this.url == null) {
            throw new WebResourceNotFoundException("View not found: " + name + " for object " + owner);
        }
        this.target = owner;
        this.bindings = new HashMap<String, Object>();
        this.bindings.put("This", this.target);
        this.bindings.put("Context", ctx);
        this.bindings.put("Engine", ctx.getEngine());
        this.bindings.put("basePath", ctx.getBasePath());
    }

    public WebContext getContext() {
        return this.ctx;
    }

    public TemplateView arg(String key, Object value) {
        this.bindings.put(key, value);
        return this;
    }

    public TemplateView args(Map<String, Object> args) {
        this.bindings.putAll(args);
        return this;
    }

    public void render(Writer writer) {
        try {
            this.ctx.getEngine().getRendering().render(this.url.toExternalForm(), this.bindings, writer);
        }
        catch (Exception e) {
            throw WebException.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            this.render(writer);
        }
        finally {
            try {
                ((Writer)writer).flush();
            }
            catch (Exception e) {
                throw WebException.wrap(e);
            }
        }
    }

    public String getString() {
        StringWriter writer = new StringWriter();
        this.render(writer);
        return writer.toString();
    }
}

