/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.session;

import org.nuxeo.ecm.webengine.session.Component;
import org.nuxeo.ecm.webengine.session.InvalidStateException;
import org.nuxeo.ecm.webengine.session.SessionException;
import org.nuxeo.ecm.webengine.session.UserSession;

public abstract class AbstractComponent
implements Component {
    private static final long serialVersionUID = 3472450841328363350L;
    protected String name;
    private boolean isLive;

    public String getName() {
        return this.name;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void initialize(UserSession session, String name) throws SessionException {
        if (this.isLive) {
            throw new InvalidStateException(this, "initialize");
        }
        this.name = name;
        this.doInitialize(session, name);
        this.isLive = true;
    }

    public void destroy(UserSession session) throws SessionException {
        if (!this.isLive) {
            throw new InvalidStateException(this, "destroy");
        }
        this.doDestroy(session);
        this.name = null;
        this.isLive = false;
    }

    public void doInitialize(UserSession session, String name) throws SessionException {
    }

    public void doDestroy(UserSession session) throws SessionException {
    }
}

