/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.session;

import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.webengine.session.Component;
import org.nuxeo.ecm.webengine.session.ComponentMap;
import org.nuxeo.ecm.webengine.session.SessionException;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserSession
extends HashMap<String, Object> {
    private static final long serialVersionUID = 260562970988817064L;
    protected static final String WE_SESSION_KEY = "nuxeo.webengine.user_session";
    private static final Log log = LogFactory.getLog(UserSession.class);
    protected Map<Class<?>, ComponentMap<?>> comps = new HashMap();
    protected final Subject subject;
    protected final Principal principal;
    protected final Object credentials;
    protected transient CoreSession coreSession;

    public static UserSession getCurrentSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return (UserSession)request.getAttribute(WE_SESSION_KEY);
        }
        return (UserSession)session.getAttribute(WE_SESSION_KEY);
    }

    public static void register(HttpServletRequest request, UserSession us) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            request.setAttribute(WE_SESSION_KEY, (Object)us);
        } else {
            session.setAttribute(WE_SESSION_KEY, (Object)us);
        }
    }

    protected UserSession(Principal principal) {
        this(principal, null);
    }

    protected UserSession(Principal principal, String password) {
        this(principal, password == null ? new char[]{} : password.toCharArray());
    }

    protected UserSession(Principal principal, Object credentials) {
        this.principal = principal;
        this.credentials = credentials;
        HashSet<Principal> principals = new HashSet<Principal>();
        HashSet<Object> publicCredentials = new HashSet<Object>();
        HashSet privateCredentials = new HashSet();
        principals.add(principal);
        publicCredentials.add(credentials);
        this.subject = new Subject(true, principals, publicCredentials, privateCredentials);
    }

    public void setCoreSession(CoreSession coreSession) {
        this.coreSession = coreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreSession getCoreSession(String repoName) {
        if (this.coreSession == null) {
            UserSession userSession = this;
            synchronized (userSession) {
                if (this.coreSession == null) {
                    try {
                        this.coreSession = UserSession.openSession(repoName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.coreSession;
    }

    public CoreSession getCoreSession() {
        return this.getCoreSession(null);
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public static CoreSession openSession(String repoName) throws Exception {
        RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        Repository repo = null;
        repo = repoName == null ? rm.getDefaultRepository() : rm.getRepository(repoName);
        if (repo == null) {
            throw new SessionException("Unable to get " + repoName + " repository");
        }
        return repo.open();
    }

    protected void install() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Installing user session");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void uninstall() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Uninstalling user session");
        }
        for (Map.Entry<Class<?>, ComponentMap<?>> entry : this.comps.entrySet()) {
            try {
                entry.getValue().destroy(this);
            }
            catch (SessionException e) {
                log.error((Object)("Failed to destroy component: " + entry.getKey()), (Throwable)e);
            }
        }
        this.comps = new HashMap();
        if (this.coreSession != null) {
            LoginContext lc = null;
            try {
                lc = Framework.loginAs((String)this.principal.getName());
                this.coreSession.destroy();
                this.coreSession = null;
            }
            catch (LoginException e) {
                log.error((Object)"Couldn't login with system user", (Throwable)e);
            }
            finally {
                if (lc != null) {
                    try {
                        lc.logout();
                    }
                    catch (LoginException loginException) {}
                }
            }
        }
    }

    public synchronized <T extends Component> T findComponent(Class<T> type, String name) {
        ComponentMap<?> map = this.comps.get(type);
        if (map == null) {
            return null;
        }
        if (name == null) {
            return (T)map.getComponent();
        }
        return (T)((Component)type.cast(map.get(name)));
    }

    public synchronized <T extends Component> T getComponent(Class<T> type, String name) throws SessionException {
        ComponentMap<Object> map = this.comps.get(type);
        Component comp = null;
        if (map == null) {
            map = new ComponentMap();
            this.comps.put(type, map);
        } else {
            comp = name == null ? (Component)map.getComponent() : (Component)type.cast(map.get(name));
            if (comp != null) {
                return (T)comp;
            }
        }
        try {
            comp = (Component)type.newInstance();
        }
        catch (Exception e) {
            throw new SessionException("Failed to instantiate component: " + type, e);
        }
        comp.initialize(this, name);
        if (name == null) {
            map.setComponent(comp);
        } else {
            map.put(name, comp);
        }
        return (T)((Component)type.cast(comp));
    }

    public <T extends Component> T getComponent(Class<T> type) throws SessionException {
        return this.getComponent(type, null);
    }

    public <T extends Component> T getComponent(String typeName, String name) throws SessionException {
        try {
            Class<?> type = Class.forName(typeName);
            return (T)this.getComponent(type, name);
        }
        catch (ClassNotFoundException e) {
            throw new SessionException("Could not find component class: " + typeName, e);
        }
    }

    public <T extends Component> T getComponent(String id) throws SessionException {
        int p = id.lastIndexOf(35);
        if (p > -1) {
            return this.getComponent(id.substring(0, p), id.substring(p + 1));
        }
        return this.getComponent(id, null);
    }

    public abstract void terminateRequest(HttpServletRequest var1);
}

