/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.utils.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathMap<T> {
    protected final Entry<T> root = new Entry();

    public void put(String path, T value) {
        this.root.put(new Path(path).segments(), value);
    }

    public void put(Path path, T value) {
        this.root.put(path.segments(), value);
    }

    public void put(String[] segments, T value) {
        this.root.put(segments, value);
    }

    public T remove(String path) {
        return this.remove(new Path(path).segments());
    }

    public T remove(Path path) {
        return this.remove(path.segments());
    }

    public T remove(String[] segments) {
        Entry<T> entry = this.root.remove(segments);
        return entry != null ? (T)entry.value : null;
    }

    public T get(String path) {
        return this.get(new Path(path).segments());
    }

    public T get(Path path) {
        return this.get(path.segments());
    }

    public T get(String[] segments) {
        Entry<T> entry = this.root.lookup(segments, true);
        return entry != null ? (T)entry.value : null;
    }

    public T match(String[] segments) {
        Entry<T> entry = this.root.lookup(segments, false);
        return entry != null ? (T)entry.value : null;
    }

    public T match(Path path) {
        return this.match(path.segments());
    }

    public T match(String path) {
        return this.match(new Path(path).segments());
    }

    public Collection<T> getValues() {
        ArrayList list = new ArrayList();
        this.collectValues(this.root, list);
        return list;
    }

    protected void collectValues(Entry<T> entry, Collection<T> list) {
        if (entry.value != null) {
            list.add(entry.value);
        }
        if (entry.entries != null) {
            for (Entry e : entry.entries.values()) {
                this.collectValues(e, list);
            }
        }
    }

    public static void main(String[] args) {
        PathMap<Path> pm = new PathMap<Path>();
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(new Path("/a/b/c"));
        paths.add(new Path("/a/b"));
        paths.add(new Path("/a"));
        paths.add(new Path("/a/b/c/d"));
        paths.add(new Path("/a/c"));
        paths.add(new Path("/a/c/d"));
        paths.add(new Path("/a/c/e"));
        double s = System.currentTimeMillis();
        for (Path p : paths) {
            pm.put(p.toString(), p);
        }
        System.out.println("pm.put: " + ((double)System.currentTimeMillis() - s) / 1000.0);
        s = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            for (Path p : paths) {
                Path path = (Path)pm.get(p);
                if (path == p) continue;
                throw new IllegalArgumentException(path.toString());
            }
        }
        System.out.println("pm.get : " + ((double)System.currentTimeMillis() - s) / 1000.0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<T> {
        Map<String, Entry<T>> entries;
        T value;

        public Entry<T> lookup(String[] segments, boolean exactMatch) {
            Entry<T> entry = this;
            Entry<T> match = null;
            for (String segment : segments) {
                if (entry.value != null) {
                    match = entry;
                }
                if (entry.entries == null) {
                    return exactMatch ? null : match;
                }
                entry = entry.entries.get(segment);
                if (entry != null) continue;
                return exactMatch ? null : match;
            }
            if (entry.value != null) {
                match = entry;
            }
            return match;
        }

        public void put(String[] segments, T value) {
            Entry<T> entry = this;
            for (String segment : segments) {
                Entry<T> newEntry;
                if (entry.entries == null) {
                    entry.entries = new HashMap<String, Entry<T>>();
                    newEntry = new Entry<T>();
                    entry.entries.put(segment, newEntry);
                } else {
                    newEntry = entry.entries.get(segment);
                    if (newEntry == null) {
                        newEntry = new Entry<T>();
                        entry.entries.put(segment, newEntry);
                    }
                }
                entry = newEntry;
            }
            entry.value = value;
        }

        public Entry<T> remove(String[] segments) {
            if (segments == null || segments.length == 0) {
                return null;
            }
            Entry<T> entry = this;
            int len = segments.length - 1;
            for (int i = 0; i < len; ++i) {
                if (entry.entries == null) {
                    return null;
                }
                entry = entry.entries.get(segments[i]);
                if (entry != null) continue;
                return null;
            }
            if (entry.entries == null) {
                return null;
            }
            return entry.entries.remove(segments[len]);
        }
    }
}

