/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.relations.jena;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.relations.api.Blank;
import org.nuxeo.ecm.platform.relations.api.Graph;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.QueryResult;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.BlankImpl;
import org.nuxeo.ecm.platform.relations.api.impl.NodeFactory;
import org.nuxeo.ecm.platform.relations.api.impl.QueryResultImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.jena.ConnectionFixInvocationHandler;
import org.nuxeo.runtime.api.DataSourceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JenaGraph
implements Graph {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JenaGraph.class);
    private transient Model memoryGraph;
    private String name;
    private String backend = "memory";
    private String datasource;
    private String databaseType;
    private String databaseUrl;
    private String databaseUser;
    private String databasePassword;
    private String databaseDriverClass;
    private boolean databaseDoCompressUri;
    private boolean databaseTransactionEnabled;
    private Map<String, String> namespaces = new HashMap<String, String>();

    protected static RuntimeException wrapException(Exception e) {
        return new RuntimeException(e);
    }

    protected GraphConnection openGraph() {
        return this.openGraph(false);
    }

    protected synchronized GraphConnection openGraph(boolean forceReload) {
        if (this.backend.equals("memory")) {
            if (this.memoryGraph == null || forceReload) {
                this.memoryGraph = ModelFactory.createDefaultModel((ReificationStyle)ModelFactory.Convenient);
                this.memoryGraph.setNsPrefixes(this.namespaces);
            }
            return new GraphConnection((Connection)null, this.memoryGraph);
        }
        if (this.backend.equals("sql")) {
            Model graph;
            ModelMaker m;
            DBConnection connection;
            Connection baseConnection = null;
            if (this.datasource != null) {
                try {
                    DataSource dataSource = DataSourceHelper.getDataSource((String)this.datasource);
                    baseConnection = dataSource.getConnection();
                    Connection wrappedConnection = (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionFixInvocationHandler(baseConnection));
                    connection = new DBConnection(wrappedConnection, this.databaseType);
                }
                catch (NamingException e) {
                    throw new IllegalArgumentException(String.format("Datasource %s not found", this.datasource), e);
                }
                catch (SQLException e) {
                    throw new IllegalArgumentException(String.format("SQLException while opening %s", this.datasource), e);
                }
            }
            try {
                Class.forName(this.databaseDriverClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Database driver class %s not found", this.databaseDriverClass), e);
            }
            connection = new DBConnection(this.databaseUrl, this.databaseUser, this.databasePassword, this.databaseType);
            if (connection.containsModel(this.name)) {
                m = ModelFactory.createModelRDBMaker((IDBConnection)connection, (ReificationStyle)ModelFactory.Convenient);
                graph = m.openModel(this.name);
            } else {
                if (connection.getAllModelNames().hasNext()) {
                    if (this.databaseDoCompressUri != connection.getDriver().getDoCompressURI()) {
                        log.warn((Object)String.format("Cannot set databaseDoCompressUri attribute to %s for model %s, other models already exist with value %s", this.databaseDoCompressUri, this.name, connection.getDriver().getDoCompressURI()));
                    }
                    if (this.databaseTransactionEnabled != connection.getDriver().getIsTransactionDb()) {
                        log.warn((Object)String.format("Cannot set databaseTransactionEnabled attribute to %s for model %s, other models already exist with value %s", this.databaseTransactionEnabled, this.name, connection.getDriver().getIsTransactionDb()));
                    }
                } else {
                    if (this.databaseDoCompressUri) {
                        connection.getDriver().setDoCompressURI(true);
                    }
                    if (this.databaseTransactionEnabled) {
                        connection.getDriver().setIsTransactionDb(true);
                    }
                }
                m = ModelFactory.createModelRDBMaker((IDBConnection)connection, (ReificationStyle)ModelFactory.Convenient);
                graph = m.createModel(this.name);
            }
            graph.setNsPrefixes(this.namespaces);
            if (baseConnection != null) {
                return new GraphConnection(baseConnection, graph);
            }
            return new GraphConnection(connection, graph);
        }
        throw new IllegalArgumentException("Unknown backend type " + this.backend);
    }

    private static Node getJenaNode(org.nuxeo.ecm.platform.relations.api.Node nuxNode) {
        Node jenaNodeInst;
        if (nuxNode == null) {
            return null;
        }
        if (nuxNode.isBlank()) {
            Blank blank = (Blank)nuxNode;
            String id = blank.getId();
            jenaNodeInst = id == null ? Node.createAnon() : Node.createAnon((AnonId)new AnonId(id));
        } else if (nuxNode.isLiteral()) {
            Literal lit = (Literal)nuxNode;
            String value = lit.getValue();
            if (value == null) {
                throw new IllegalArgumentException(String.format("Invalid literal node %s", nuxNode));
            }
            String language = lit.getLanguage();
            String type = lit.getType();
            jenaNodeInst = language != null ? Node.createLiteral((String)value, (String)language, (boolean)false) : (type != null ? Node.createLiteral((String)value, null, (RDFDatatype)new BaseDatatype(type)) : Node.createLiteral((String)value));
        } else if (nuxNode.isResource()) {
            org.nuxeo.ecm.platform.relations.api.Resource resource = (org.nuxeo.ecm.platform.relations.api.Resource)nuxNode;
            String uri = resource.getUri();
            jenaNodeInst = Node.createURI((String)uri);
        } else {
            throw new IllegalArgumentException(String.format("Invalid NXRelations node %s", nuxNode));
        }
        return jenaNodeInst;
    }

    private org.nuxeo.ecm.platform.relations.api.Node getNXRelationsNode(Node jenaNodeInst) {
        if (jenaNodeInst == null) {
            return null;
        }
        BlankImpl nuxNode = null;
        if (jenaNodeInst.isBlank()) {
            AnonId anonId = jenaNodeInst.getBlankNodeId();
            String id = anonId.getLabelString();
            nuxNode = NodeFactory.createBlank((String)id);
        } else if (jenaNodeInst.isLiteral()) {
            LiteralLabel label = jenaNodeInst.getLiteral();
            String value = label.getLexicalForm();
            String type = jenaNodeInst.getLiteralDatatypeURI();
            String language = jenaNodeInst.getLiteralLanguage();
            nuxNode = type != "" ? NodeFactory.createTypedLiteral((String)value, (String)type) : (language != "" ? NodeFactory.createLiteral((String)value, (String)language) : NodeFactory.createLiteral((String)value));
        } else if (jenaNodeInst.isURI()) {
            String uri = jenaNodeInst.getURI();
            for (Map.Entry<String, String> ns : this.namespaces.entrySet()) {
                String base = ns.getValue();
                if (!uri.startsWith(base)) continue;
                String localName = uri.substring(base.length());
                nuxNode = NodeFactory.createQNameResource((String)base, (String)localName);
                break;
            }
            if (nuxNode == null) {
                nuxNode = NodeFactory.createResource((String)uri);
            }
        } else {
            throw new IllegalArgumentException("Cannot translate non concrete Jena node into NXRelations node");
        }
        return nuxNode;
    }

    private static SimpleSelector getJenaSelector(Model graph, Statement nuxStatement) {
        Resource subjResource = null;
        Node subject = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)nuxStatement.getSubject());
        if (subject != null && subject.isURI()) {
            subjResource = graph.getResource(subject.getURI());
        }
        Property predProp = null;
        Node predicate = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)nuxStatement.getPredicate());
        if (predicate != null && predicate.isURI()) {
            predProp = graph.getProperty(predicate.getURI());
        }
        Node object = JenaGraph.getJenaNode(nuxStatement.getObject());
        RDFNode objRDF = null;
        if (object != null) {
            objRDF = graph.asRDFNode(object);
        }
        return new SimpleSelector(subjResource, predProp, objRDF);
    }

    private Statement getNXRelationsStatement(Model graph, com.hp.hpl.jena.rdf.model.Statement jenaStatement) {
        org.nuxeo.ecm.platform.relations.api.Node subject = this.getNXRelationsNode(jenaStatement.getSubject().asNode());
        org.nuxeo.ecm.platform.relations.api.Node predicate = this.getNXRelationsNode(jenaStatement.getPredicate().asNode());
        org.nuxeo.ecm.platform.relations.api.Node object = this.getNXRelationsNode(jenaStatement.getObject().asNode());
        StatementImpl statement = new StatementImpl(subject, predicate, object);
        if (graph.isReified(jenaStatement)) {
            Resource reifiedStmt = graph.getAnyReifiedStatement(jenaStatement);
            StmtIterator it = reifiedStmt.listProperties();
            while (it.hasNext()) {
                com.hp.hpl.jena.rdf.model.Statement stmt = it.nextStatement();
                org.nuxeo.ecm.platform.relations.api.Node nuxNode = this.getNXRelationsNode(stmt.getPredicate().asNode());
                org.nuxeo.ecm.platform.relations.api.Node value = this.getNXRelationsNode(stmt.getObject().asNode());
                statement.addProperty((org.nuxeo.ecm.platform.relations.api.Resource)nuxNode, value);
            }
        }
        return statement;
    }

    private List<Statement> getNXRelationsStatements(Model graph, List<com.hp.hpl.jena.rdf.model.Statement> jenaStatements) {
        ArrayList<Statement> nuxStmts = new ArrayList<Statement>();
        for (com.hp.hpl.jena.rdf.model.Statement jenaStmt : jenaStatements) {
            if (jenaStmt.getSubject().canAs(ReifiedStatement.class)) continue;
            nuxStmts.add(this.getNXRelationsStatement(graph, jenaStmt));
        }
        return nuxStmts;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Map<String, String> options) {
        for (Map.Entry<String, String> option : options.entrySet()) {
            String key = option.getKey();
            String value = option.getValue();
            if (key.equals("backend")) {
                if (value.equals("memory") || value.equals("sql")) {
                    this.backend = value;
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unknown backend %s for Jena graph", value));
            }
            if (key.equals("datasource")) {
                this.datasource = value;
                continue;
            }
            if (key.equals("databaseType")) {
                this.databaseType = value;
                continue;
            }
            if (key.equals("databaseUrl")) {
                this.databaseUrl = value;
                continue;
            }
            if (key.equals("databaseUser")) {
                this.databaseUser = value;
                continue;
            }
            if (key.equals("databasePassword")) {
                this.databasePassword = value;
                continue;
            }
            if (key.equals("databaseDriverClass")) {
                this.databaseDriverClass = value;
                continue;
            }
            if (key.equals("databaseDoCompressUri")) {
                if (value.equals("true")) {
                    this.databaseDoCompressUri = true;
                    continue;
                }
                if (value.equals("false")) {
                    this.databaseDoCompressUri = false;
                    continue;
                }
                String format = "Illegal value %s for databaseDoCompressUri, must be true or false";
                throw new IllegalArgumentException(String.format(format, value));
            }
            if (!key.equals("databaseTransactionEnabled")) continue;
            if (value.equals("true")) {
                this.databaseTransactionEnabled = true;
                continue;
            }
            if (value.equals("false")) {
                this.databaseTransactionEnabled = false;
                continue;
            }
            String format = "Illegal value %s for databaseTransactionEnabled, must be true or false";
            throw new IllegalArgumentException(String.format(format, value));
        }
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = new HashMap<String, String>();
        this.namespaces.putAll(namespaces);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void add(List<Statement> statements) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(false);
            for (Statement nuxStmt : statements) {
                Node subject = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)nuxStmt.getSubject());
                Node predicate = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)nuxStmt.getPredicate());
                Node object = JenaGraph.getJenaNode(nuxStmt.getObject());
                Triple jenaTriple = Triple.create((Node)subject, (Node)predicate, (Node)object);
                com.hp.hpl.jena.rdf.model.Statement jenaStmt = graph.asStatement(jenaTriple);
                Map properties = nuxStmt.getProperties();
                if (properties == null || properties.isEmpty()) {
                    graph.add(jenaStmt);
                    continue;
                }
                ArrayList<com.hp.hpl.jena.rdf.model.Statement> stmts = new ArrayList<com.hp.hpl.jena.rdf.model.Statement>();
                stmts.add(jenaStmt);
                Node reifiedStmt = graph.getAnyReifiedStatement(jenaStmt).asNode();
                for (Map.Entry property : properties.entrySet()) {
                    Node prop = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)property.getKey());
                    for (org.nuxeo.ecm.platform.relations.api.Node node : (org.nuxeo.ecm.platform.relations.api.Node[])property.getValue()) {
                        Node value = JenaGraph.getJenaNode(node);
                        Triple propTriple = Triple.create((Node)reifiedStmt, (Node)prop, (Node)value);
                        stmts.add(graph.asStatement(propTriple));
                    }
                }
                graph.add(stmts);
            }
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public void remove(List<Statement> statements) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(false);
            for (Statement nuxStmt : statements) {
                Node subject = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)nuxStmt.getSubject());
                Node predicate = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)nuxStmt.getPredicate());
                Node object = JenaGraph.getJenaNode(nuxStmt.getObject());
                Triple jenaTriple = Triple.create((Node)subject, (Node)predicate, (Node)object);
                com.hp.hpl.jena.rdf.model.Statement jenaStmt = graph.asStatement(jenaTriple);
                graph.remove(jenaStmt);
                RSIterator it = graph.listReifiedStatements(jenaStmt);
                while (it.hasNext()) {
                    ReifiedStatement rs = it.nextRS();
                    rs.removeProperties();
                }
                graph.removeAllReifications(jenaStmt);
            }
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public List<Statement> getStatements() {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            StmtIterator it = graph.listStatements();
            List<Statement> list = this.getNXRelationsStatements(graph, it.toList());
            return list;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public List<Statement> getStatements(Statement statement) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            SimpleSelector selector = JenaGraph.getJenaSelector(graph, statement);
            StmtIterator it = graph.listStatements((Selector)selector);
            List<Statement> list = this.getNXRelationsStatements(graph, it.toList());
            return list;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public List<org.nuxeo.ecm.platform.relations.api.Node> getSubjects(org.nuxeo.ecm.platform.relations.api.Node predicate, org.nuxeo.ecm.platform.relations.api.Node object) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            SimpleSelector selector = JenaGraph.getJenaSelector(graph, (Statement)new StatementImpl(null, predicate, object));
            ResIterator it = graph.listSubjectsWithProperty(selector.getPredicate(), selector.getObject());
            ArrayList<org.nuxeo.ecm.platform.relations.api.Node> res = new ArrayList<org.nuxeo.ecm.platform.relations.api.Node>();
            while (it.hasNext()) {
                res.add(this.getNXRelationsNode(it.nextResource().asNode()));
            }
            ArrayList<org.nuxeo.ecm.platform.relations.api.Node> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public List<org.nuxeo.ecm.platform.relations.api.Node> getPredicates(org.nuxeo.ecm.platform.relations.api.Node subject, org.nuxeo.ecm.platform.relations.api.Node object) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            SimpleSelector selector = JenaGraph.getJenaSelector(graph, (Statement)new StatementImpl(subject, null, object));
            StmtIterator it = graph.listStatements((Selector)selector);
            List<Statement> statements = this.getNXRelationsStatements(graph, it.toList());
            ArrayList<org.nuxeo.ecm.platform.relations.api.Node> res = new ArrayList<org.nuxeo.ecm.platform.relations.api.Node>();
            for (Statement stmt : statements) {
                org.nuxeo.ecm.platform.relations.api.Resource predicate = stmt.getPredicate();
                if (res.contains(predicate)) continue;
                res.add((org.nuxeo.ecm.platform.relations.api.Node)predicate);
            }
            ArrayList<org.nuxeo.ecm.platform.relations.api.Node> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public List<org.nuxeo.ecm.platform.relations.api.Node> getObjects(org.nuxeo.ecm.platform.relations.api.Node subject, org.nuxeo.ecm.platform.relations.api.Node predicate) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            SimpleSelector selector = JenaGraph.getJenaSelector(graph, (Statement)new StatementImpl(subject, predicate, null));
            NodeIterator it = graph.listObjectsOfProperty(selector.getSubject(), selector.getPredicate());
            ArrayList<org.nuxeo.ecm.platform.relations.api.Node> res = new ArrayList<org.nuxeo.ecm.platform.relations.api.Node>();
            while (it.hasNext()) {
                res.add(this.getNXRelationsNode(it.nextNode().asNode()));
            }
            ArrayList<org.nuxeo.ecm.platform.relations.api.Node> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public boolean hasStatement(Statement statement) {
        if (statement == null) {
            return false;
        }
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            SimpleSelector selector = JenaGraph.getJenaSelector(graph, statement);
            boolean bl = graph.contains(selector.getSubject(), selector.getPredicate(), selector.getObject());
            return bl;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public boolean hasResource(org.nuxeo.ecm.platform.relations.api.Resource resource) {
        if (resource == null) {
            return false;
        }
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            Node jenaNodeInst = JenaGraph.getJenaNode((org.nuxeo.ecm.platform.relations.api.Node)resource);
            RDFNode jenaNode = graph.asRDFNode(jenaNodeInst);
            boolean bl = graph.containsResource(jenaNode);
            return bl;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public Long size() {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            Long l = graph.size();
            return l;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public void clear() {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            graph.removeAll();
            RSIterator it = graph.listReifiedStatements();
            ArrayList<ReifiedStatement> rss = new ArrayList<ReifiedStatement>();
            while (it.hasNext()) {
                rss.add(it.nextRS());
            }
            for (ReifiedStatement rs : rss) {
                graph.removeReification(rs);
            }
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public QueryResult query(String queryString, String language, String baseURI) {
        Model graph = null;
        GraphConnection graphConnection = null;
        QueryResultImpl res = null;
        QueryExecution qe = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            log.debug((Object)String.format("Running query %s", queryString));
            if (language != null && !language.equals("sparql")) {
                log.warn((Object)String.format("Unknown language %s for query, using SPARQL", language));
            }
            Query query = QueryFactory.create((String)queryString);
            query.setBaseURI(baseURI);
            qe = QueryExecutionFactory.create((Query)query, (Model)graph);
            res = new QueryResultImpl(Integer.valueOf(0), new ArrayList(), new ArrayList());
            ResultSet jenaResults = qe.execSelect();
            Integer count = 0;
            List variableNames = jenaResults.getResultVars();
            ArrayList nuxResults = new ArrayList();
            while (jenaResults.hasNext()) {
                QuerySolution soln = jenaResults.nextSolution();
                HashMap<String, org.nuxeo.ecm.platform.relations.api.Node> nuxSol = new HashMap<String, org.nuxeo.ecm.platform.relations.api.Node>();
                for (String varName : variableNames) {
                    RDFNode x = soln.get(varName);
                    nuxSol.put(varName, this.getNXRelationsNode(x.asNode()));
                }
                nuxResults.add(nuxSol);
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            res = new QueryResultImpl(count, variableNames, nuxResults);
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (qe != null) {
                qe.close();
            }
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
        return res;
    }

    public boolean read(InputStream in, String lang, String base) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(true);
            graph.read(in, base, lang);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public boolean read(String path, String lang, String base) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            boolean bl = this.read(in, lang, base);
            return bl;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public boolean write(OutputStream out, String lang, String base) {
        Model graph = null;
        GraphConnection graphConnection = null;
        try {
            graphConnection = this.openGraph();
            graph = graphConnection.getGraph();
            graph.enterCriticalSection(false);
            graph.write(out, lang, base);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (graph != null) {
                graph.leaveCriticalSection();
            }
            if (graphConnection != null) {
                graphConnection.close();
            }
        }
    }

    public boolean write(String path, String lang, String base) {
        OutputStream out = null;
        try {
            File file = new File(path);
            out = new FileOutputStream(file);
            boolean bl = this.write(out, lang, base);
            return bl;
        }
        catch (Exception e) {
            throw JenaGraph.wrapException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected static final class GraphConnection {
        private final Connection baseConnection;
        private final DBConnection connection;
        private final Model graph;

        GraphConnection(DBConnection connection, Model graph) {
            this.baseConnection = null;
            this.connection = connection;
            this.graph = graph;
        }

        GraphConnection(Connection baseConnection, Model graph) {
            this.baseConnection = baseConnection;
            this.connection = null;
            this.graph = graph;
        }

        public Model getGraph() {
            return this.graph;
        }

        protected void close() {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    log.error((Object)"Could not close connection");
                }
            }
            if (this.baseConnection != null) {
                try {
                    this.baseConnection.close();
                }
                catch (SQLException e) {
                    log.error((Object)"Could not close base connection");
                }
            }
        }
    }
}

