/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.configuration;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationFilter
implements IsSerializable {
    private String name;
    private String icon;
    private String type;
    private String author;
    private Map<String, String> fields;
    private List<String> parameters = new ArrayList<String>();

    public AnnotationFilter() {
    }

    public AnnotationFilter(String name, String icon, String type, String author, Map<String, String> fields) {
        this.name = name;
        this.icon = icon;
        if ("".equals(type)) {
            this.parameters.add("{http://www.w3.org/1999/02/22-rdf-syntax-ns#}type");
        } else {
            this.type = type;
        }
        if ("".equals(author)) {
            this.parameters.add("{http://purl.org/dc/elements/1.1/}creator");
        } else {
            this.author = author;
        }
        this.fields = fields;
        if (fields != null) {
            ArrayList<String> fieldNames = new ArrayList<String>(fields.keySet());
            for (String fieldName : fieldNames) {
                if (!"".equals(fields.get(fieldName))) continue;
                this.parameters.add(fieldName);
                fields.remove(fieldName);
            }
        }
    }

    public boolean accept(Annotation annotation) {
        boolean accept = true;
        if (this.type != null) {
            accept &= this.type.equals(annotation.getShortType());
        }
        if (this.author != null) {
            accept &= this.author.equals(annotation.getAuthor());
        }
        if (this.fields != null) {
            for (String name : this.fields.keySet()) {
                accept &= this.fields.get(name).equals(annotation.getFields().get(name));
            }
        }
        return accept;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public String getField(String name) {
        return this.fields.get(name);
    }

    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    public void setField(String name, String value) {
        this.fields.put(name, value);
    }

    public void removeField(String name) {
        this.fields.remove(name);
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }
}

