/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.controler;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.annotations.gwt.client.annotea.AnnoteaClient;
import org.nuxeo.ecm.platform.annotations.gwt.client.configuration.WebConfiguration;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationChangeListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationModel;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Point;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.StringRangeXPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointerFactory;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.AnnotatedDocument;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.NewAnnotationPopup;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.listener.AnnotationPopupEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationController {
    private static AnnotationController CURRENT_INSTANCE;
    private static AnnotationModel model;
    private static NewAnnotationPopup newAnnotationPopup;
    private static AnnotatedDocument annotatedDocument;
    private static final List<AnnotationPopupEventListener> annotationPopupListeners;
    private String xPointerFilter;
    private String pointerAdapter;
    private boolean annotateImageOnly;
    private boolean multiImage;
    private final AnnoteaClient annoteaClient;
    private final WebConfiguration webConfiguration;
    private int frameScrollFromTop;
    private boolean creationPopupOpened = false;
    private boolean onFrame;

    public AnnotationController(WebConfiguration webConfiguration, boolean onFrame) {
        this.onFrame = onFrame;
        this.webConfiguration = webConfiguration == null ? WebConfiguration.DEFAULT_WEB_CONFIGURATION : webConfiguration;
        this.annoteaClient = new AnnoteaClient(this);
        CURRENT_INSTANCE = this;
        if (onFrame) {
            annotatedDocument = new AnnotatedDocument(this);
            model.addChangeListener(annotatedDocument);
            this.registerOnFrameMethods();
        } else {
            this.registerMainModuleMethods();
        }
    }

    private native void registerOnFrameMethods();

    private native void registerMainModuleMethods();

    public void addNewAnnotation() {
        NewAnnotationPopup popup = this.getNewAnnotationPopup();
        Annotation annotation = this.getNewAnnotation();
        if (popup != null && annotation != null) {
            if (annotation.getXpointer() instanceof StringRangeXPointer) {
                annotatedDocument.decorateSelectedText(annotation);
            }
            popup.show();
        }
    }

    public WebConfiguration getWebConfiguration() {
        return this.webConfiguration;
    }

    public AnnotatedDocument getAnnotatedDocument() {
        return annotatedDocument;
    }

    public void setXPointerFilter(String pointerFilter) {
        this.xPointerFilter = pointerFilter;
    }

    public void setPointerAdapter(String pointerAdapter) {
        this.pointerAdapter = pointerAdapter;
    }

    public boolean canAnnotate() {
        return this.webConfiguration.canAnnotate();
    }

    public void addModelChangeListener(AnnotationChangeListener listener) {
        model.addChangeListener(listener);
    }

    public int getFrameScrollFromTop() {
        return this.frameScrollFromTop;
    }

    public void setFrameScrollFromTop(int frameScrollFromTop) {
        this.frameScrollFromTop = frameScrollFromTop;
    }

    public boolean canCreateNewCreationPopup() {
        return !this.creationPopupOpened;
    }

    public void openCreationPopup() {
        this.creationPopupOpened = true;
    }

    public void closeCreationPopup() {
        this.creationPopupOpened = false;
    }

    public void newAnnotationCreated(Annotation annotation) {
        model.setNewAnnotation(annotation);
    }

    public void submitNewAnnotation() {
        GWT.log((String)"submiting new annotation", null);
        Annotation newAnnotation = model.getNewAnnotation();
        this.annoteaClient.submitAnnotation(newAnnotation);
        model.setNewAnnotation(null);
        this.setSelectedAnnotationIndex(model.getAnnotations().size());
    }

    private native void setSelectedAnnotationIndex(int var1);

    public void reloadAnnotations() {
        if (this.onFrame) {
            this.reloadAnnotationsOnMainModule();
        } else {
            this.reloadAnnotationsOnFrame();
        }
    }

    private native void reloadAnnotationsOnMainModule();

    private native void reloadAnnotationsOnFrame();

    public void cancelNewAnnotation() {
        model.setNewAnnotation(null);
    }

    public void cancelNewAnnotationPopup() {
        if (newAnnotationPopup != null) {
            newAnnotationPopup.cancel();
        }
    }

    public void createNewAnnotation(String pointer) {
        String href = this.getTopWindowUrl();
        String xpointerURI = href.substring(0, href.lastIndexOf("/") + 1) + pointer;
        Annotation newAnnotation = new Annotation(XPointerFactory.getXPointer(xpointerURI));
        model.setNewAnnotation(newAnnotation);
    }

    public void setAnnotationList(List<Annotation> annotations) {
        model.setAnnotations(annotations);
    }

    public native String getAnnoteaServerUrl();

    public Annotation getNewAnnotation() {
        return model.getNewAnnotation();
    }

    public void loadAnnotations() {
        if (this.onFrame && !this.isMultiImage()) {
            annotatedDocument.preDecorateDocument();
        }
        this.annoteaClient.getAnnotationList(this.getTopWindowUrl());
    }

    public String getTopWindowUrl() {
        if (this.onFrame) {
            return this.getParentWindowUrl();
        }
        return this.getCurrentWindowUrl();
    }

    protected native String getParentWindowUrl();

    protected native String getCurrentWindowUrl();

    public void decorateDocument() {
        Log.debug((String)"decorate document");
        annotatedDocument.preDecorateDocument();
        AnnotationController.updateAnnotation(true);
    }

    public void updateSelectedAnnotation(int index) {
        annotatedDocument.updateSelectedAnnotation(index);
    }

    public void setFirstAnnotationSelected() {
        if (!model.getAnnotations().isEmpty()) {
            annotatedDocument.updateSelectedAnnotation(0);
        }
    }

    public void setCancelNewAnnotation() {
        model.setNewAnnotation(null);
    }

    public void setImageOnly(boolean b) {
        this.annotateImageOnly = b;
    }

    public boolean isImageOnly() {
        return this.annotateImageOnly;
    }

    public void setMultiImage(boolean b) {
        this.multiImage = b;
    }

    public boolean isMultiImage() {
        return this.multiImage;
    }

    public String filterXPointer(ImageElement image, String xpath, int i, int j, int k, int l) {
        if (this.xPointerFilter != null) {
            return this.filter(this.xPointerFilter, image, xpath, i, j, k, l);
        }
        return "#xpointer(image-range(" + xpath + ",[" + i + "," + j + "],[" + k + "," + l + "]))";
    }

    public native String filter(String var1, ImageElement var2, String var3, int var4, int var5, int var6, int var7);

    public Point[] filterAnnotation(Point topLeft, Point bottomRight) {
        if (this.pointerAdapter == null) {
            return new Point[]{topLeft, bottomRight};
        }
        String result = this.filterPoint(this.pointerAdapter, topLeft.getX(), topLeft.getY(), bottomRight.getX(), bottomRight.getY());
        if (result.equals("")) {
            return null;
        }
        String[] points = result.split(":");
        return new Point[]{new Point(points[0]), new Point(points[1])};
    }

    private native String filterPoint(String var1, int var2, int var3, int var4, int var5);

    public static void updateAnnotation(boolean forceDecorate) {
        CURRENT_INSTANCE.updateAnnotations(forceDecorate);
    }

    public static void updateAnnotation() {
        AnnotationController.updateAnnotation(false);
    }

    public void updateAnnotations(boolean forceDecorate) {
        annotatedDocument.update(forceDecorate);
    }

    public native void setAnnotationDecoratorFunction(String var1);

    public void setNewAnnotationPopup(NewAnnotationPopup popup) {
        newAnnotationPopup = popup;
    }

    public NewAnnotationPopup getNewAnnotationPopup() {
        return newAnnotationPopup;
    }

    public void hideAnnotations() {
        annotatedDocument.hideAnnotations();
        this.disablePopupListeners();
    }

    public void disablePopupListeners() {
        for (AnnotationPopupEventListener listener : annotationPopupListeners) {
            listener.disable();
        }
    }

    public void showAnnotations() {
        annotatedDocument.showAnnotations();
        this.enablePopupListeners();
    }

    public void enablePopupListeners() {
        for (AnnotationPopupEventListener listener : annotationPopupListeners) {
            listener.enable();
        }
    }

    public void registerAnnotationPopupListener(AnnotationPopupEventListener listener) {
        annotationPopupListeners.add(listener);
    }

    public void removeAnnotationPopupListener(AnnotationPopupEventListener listener) {
        annotationPopupListeners.remove(listener);
    }

    public String getDecorateClassName() {
        if (annotatedDocument.isAnnotationsVisible()) {
            return "decorate";
        }
        return "decorateNot";
    }

    public native void deleteAnnotation(int var1);

    private void deleteAnnotationOnFrame(int index) {
        this.annoteaClient.deleteAnnotation(Window.Location.getHref(), model.getAnnotations().get(index));
    }

    public native boolean isAnnotationsVisible();

    public void removeSelectedTextDecoration() {
        annotatedDocument.removeSelectedTextDecoration(this.getNewAnnotation());
    }

    static {
        model = new AnnotationModel();
        annotationPopupListeners = new ArrayList<AnnotationPopupEventListener>();
    }
}

