/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.model;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Container;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation {
    private String uuid;
    private XPointer xpointer;
    private boolean isBodyUrl;
    private Date date;
    private String formattedDate = "";
    private String author;
    private String body;
    private String type;
    private int id;
    private Map<String, String> fields = new HashMap<String, String>();
    private Container startContainer;
    private Container endContainer;

    public Annotation(String uuid) {
        this.uuid = uuid;
    }

    public Annotation() {
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStringDate(String stringDate) {
        this.date = Annotation.computeDate(stringDate);
        this.formattedDate = DateTimeFormat.getShortDateFormat().format(this.date);
    }

    public Annotation(XPointer xpointer) {
        this.xpointer = xpointer;
    }

    public boolean isBodyUrl() {
        return this.isBodyUrl;
    }

    public void setBodyUrl(boolean isBodyUrl) {
        this.isBodyUrl = isBodyUrl;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getType() {
        return this.type;
    }

    public String getShortType() {
        return this.type.substring(this.type.lastIndexOf("#") + 1);
    }

    public void setType(String type) {
        this.type = type;
    }

    public XPointer getXpointer() {
        return this.xpointer;
    }

    public String serialize() {
        return this.type + ' ' + this.xpointer + ' ' + this.body;
    }

    public void setXpointer(XPointer xpointer) {
        this.xpointer = xpointer;
    }

    public String getFormattedDate() {
        return this.formattedDate;
    }

    public Date getDate() {
        return this.date;
    }

    private static Date computeDate(String stringDate) {
        String d = stringDate.substring(0, stringDate.indexOf("T"));
        String t = stringDate.substring(stringDate.indexOf("T") + 1, stringDate.indexOf("Z"));
        String[] ds = d.split("-");
        String[] ts = t.split(":");
        Date now = new Date();
        int second = ts.length == 3 ? Integer.parseInt(ts[2]) : 0;
        now = new Date(Date.UTC(Integer.parseInt(ds[0]) - 1900, Integer.parseInt(ds[1]) - 1, Integer.parseInt(ds[2]), Integer.parseInt(ts[0]), Integer.parseInt(ts[1]), second) + (long)now.getTimezoneOffset());
        return now;
    }

    public void setFields(Map<String, String> fields) {
        this.fields = fields;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Container getStartContainer() {
        return this.startContainer;
    }

    public void setStartContainer(Container container) {
        this.startContainer = container;
    }

    public boolean hasStartContainer() {
        return this.startContainer != null;
    }

    public Container getEndContainer() {
        return this.endContainer;
    }

    public void setEndContainer(Container container) {
        this.endContainer = container;
    }

    public boolean hasEndContainer() {
        return this.endContainer != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Annotation)) {
            return false;
        }
        Annotation annotation = (Annotation)obj;
        return this.xpointer.equals(annotation.xpointer) && this.author.equals(annotation.author);
    }

    public int hashCode() {
        int result = 17;
        result += 17 * this.xpointer.hashCode();
        return result += 17 * this.author.hashCode();
    }
}

