/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.util;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPathUtil;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointer;

public class StringRangeXPointer
implements XPointer {
    private final XPathUtil pathUtil = new XPathUtil();
    private final String url;
    private final String path;
    private final int startOffset;
    private final int length;
    private String xpointerString;

    public StringRangeXPointer(String xpointer) {
        this.xpointerString = xpointer;
        this.url = xpointer.substring(0, xpointer.indexOf("#"));
        xpointer = xpointer.replaceFirst(".*string-range\\(", "");
        xpointer = xpointer.replaceFirst("\\)\\)$", "");
        String[] args = xpointer.split(",");
        this.path = args[0];
        this.startOffset = Integer.parseInt(args[2].trim());
        this.length = Integer.parseInt(args[3].trim());
    }

    public int getLength() {
        return this.length;
    }

    public String getMethod() {
        return "string-range";
    }

    public String getUrl() {
        return this.url;
    }

    public String getXPath() {
        return this.path;
    }

    public Node getFirstNode() {
        return this.pathUtil.getNode(this.path, Document.get()).get(0);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public Document getOwnerDocument() {
        return Document.get();
    }

    public String getXpointerString() {
        return this.xpointerString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringRangeXPointer)) {
            return false;
        }
        StringRangeXPointer xp = (StringRangeXPointer)obj;
        return this.xpointerString.equals(xp.xpointerString);
    }

    public int hashCode() {
        int result = 17;
        return result += 17 * this.xpointerString.hashCode();
    }
}

