/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater.Annotater;

public abstract class AbstractAnnotater
implements Annotater {
    protected final AnnotationController controller;
    private final boolean eventPreventDefault;
    private boolean onMouseDown;
    private boolean onMouseMove = false;

    public AbstractAnnotater(AnnotationController controller, boolean eventPreventDefault) {
        this.controller = controller;
        this.eventPreventDefault = eventPreventDefault;
    }

    public void manageEvent(Event event) {
        if (!this.controller.canCreateNewCreationPopup() || !this.controller.canAnnotate()) {
            return;
        }
        if (this.eventPreventDefault) {
            DOM.eventPreventDefault((Event)event);
        }
        switch (event.getTypeInt()) {
            case 4: {
                this.onMouseDown(event);
                break;
            }
            case 64: {
                this.onMouseMove(event);
                break;
            }
            case 8: {
                this.onMouseUp(event);
                break;
            }
            case 32: {
                this.onMouseOut(event);
            }
        }
    }

    public void onMouseDown(Event event) {
        this.onMouseDown = true;
    }

    public void onMouseMove(Event event) {
        if (this.onMouseDown) {
            this.onMouseMove = true;
        }
    }

    public void onMouseUp(Event event) {
        this.onMouseMove = false;
        this.onMouseDown = false;
    }

    public void onMouseOut(Event event) {
        this.onMouseUp(event);
    }

    public boolean hasMoved() {
        return this.onMouseMove;
    }

    protected void addAnnotationPopup() {
        this.controller.addNewAnnotation();
    }
}

