/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Text;
import com.google.gwt.user.client.Event;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Container;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Range;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Utils;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPathUtil;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.NewAnnotationPopup;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater.AbstractAnnotater;

public class TextAnnotater
extends AbstractAnnotater {
    private final XPathUtil xpathUtil = new XPathUtil();

    public TextAnnotater(AnnotationController controller) {
        super(controller, false);
    }

    public void onMouseUp(Event event) {
        Log.debug((String)("TextAnnotater#onMouseUp; eventId= " + event.getType() + "; source: " + event.getCurrentTarget()));
        Range currentRange = Utils.getCurrentRange(Document.get());
        if (currentRange != null && currentRange.getSelectedText().length() != 0) {
            Element startElement = Element.as((Node)currentRange.getStartContainer());
            String pointer = this.xpathUtil.getSelectionXPointer(currentRange);
            this.controller.createNewAnnotation(pointer);
            Container startContainer = this.getStartContainer(currentRange);
            Container endContainer = this.getEndContainer(currentRange);
            Annotation annotation = this.controller.getNewAnnotation();
            annotation.setStartContainer(startContainer);
            annotation.setEndContainer(endContainer);
            NewAnnotationPopup popup = new NewAnnotationPopup(startElement, this.controller, false, "local");
            this.controller.setNewAnnotationPopup(popup);
            this.addAnnotationPopup();
        } else {
            this.controller.setNewAnnotationPopup(null);
        }
        super.onMouseUp(event);
    }

    private Container getStartContainer(Range range) {
        Node startNode = range.getStartContainer();
        int startOffset = range.getStartOffset();
        startOffset = TextAnnotater.computeNewOffset(startNode, startOffset);
        if (startNode.getNodeType() == 3) {
            return this.getCustomContainer(startNode, startOffset);
        }
        return new Container(this.xpathUtil.getXPath(startNode), startOffset);
    }

    private Container getCustomContainer(Node node, int currentOffset) {
        int offset = 0;
        for (Node n = node.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
            if (n.getNodeType() == 3) {
                Text text = (Text)n;
                offset += text.getLength();
                continue;
            }
            if (n.getNodeType() != 1) continue;
            Element ele = (Element)n;
            offset += ele.getInnerText().length();
        }
        node = node.getParentNode();
        return new Container(this.xpathUtil.getXPath(node), currentOffset += offset);
    }

    private static int computeNewOffset(Node node, int currentOffset) {
        if (currentOffset <= 0) {
            return currentOffset;
        }
        int difference = 0;
        String text = node.getNodeValue();
        if (text != null) {
            text = text.substring(0, currentOffset);
            String processedText = Utils.removeWhitespaces(text, node, true);
            difference = text.length() - processedText.length();
        }
        return currentOffset - difference;
    }

    private Container getEndContainer(Range range) {
        Node endNode = range.getEndContainer();
        int endOffset = range.getEndOffset();
        endOffset = TextAnnotater.computeNewOffset(endNode, endOffset);
        if (endNode.getNodeType() == 3) {
            return this.getCustomContainer(endNode, endOffset);
        }
        return new Container(this.xpathUtil.getXPath(endNode), endOffset);
    }
}

