/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Text;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.EventListener;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.Annotation;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator.DecoratorVisitor;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.listener.AnnotationPopupEventListener;

public class AnnoteaDecoratorVisitor
implements DecoratorVisitor {
    private boolean decorating;
    private boolean previousIsCarriageReturnElement;
    private static List<String> carriagesReturnedElements = new ArrayList<String>();
    private boolean lastCharIsSpace;
    private final Node startNode;
    private boolean started;
    private int offset;
    private int textToAnnotate;
    private final Annotation annotation;
    private final AnnotationController controller;

    public AnnoteaDecoratorVisitor(Node startNode, int annotatedText, int offset, Annotation annotation, AnnotationController controller) {
        this.startNode = startNode;
        this.textToAnnotate = annotatedText;
        this.offset = offset;
        this.annotation = annotation;
        this.controller = controller;
    }

    public boolean isLastCharIsSpace() {
        return this.lastCharIsSpace;
    }

    public void setLastCharIsSpace(boolean lastCharIsSpace) {
        this.lastCharIsSpace = lastCharIsSpace;
    }

    public boolean doBreak() {
        return this.textToAnnotate == 0;
    }

    public void process(Node node) {
        if (node.equals((Object)this.startNode)) {
            this.started = true;
        } else if (this.started) {
            if (!this.decorating) {
                this.processToFirstNode(node);
            } else {
                this.processNode(node);
            }
            this.previousIsCarriageReturnElement = carriagesReturnedElements.contains(node.getNodeName().toLowerCase());
        }
    }

    private void insertBefore(Node parent, Node child, Node newChild) {
        if (child == null) {
            parent.appendChild(newChild);
        } else {
            parent.insertBefore(newChild, child);
        }
    }

    private void processNode(Node node) {
        if (node.getNodeType() != 3) {
            if (node.getNodeName().equalsIgnoreCase("td")) {
                --this.textToAnnotate;
            }
            return;
        }
        Text text = (Text)node;
        Node parent = text.getParentNode();
        String data = text.getData();
        this.processDecoratedNode(node, data, parent);
        node.getParentNode().removeChild(node);
    }

    public String[] getSelectedText(String rawText, int length) {
        String text = "";
        for (int x = 0; x <= rawText.length(); ++x) {
            text = rawText.substring(0, x);
            if ((text = this.removeWhiteSpace(text)).length() != length) continue;
            return new String[]{text, rawText.substring(0, x), rawText.substring(x)};
        }
        return new String[]{text, rawText, ""};
    }

    public String removeWhiteSpace(String data) {
        data = data.replaceAll("\\s+", " ");
        boolean startWithSpace = data.startsWith(" ");
        boolean endWithSpace = data.endsWith(" ");
        data = data.trim();
        if (this.lastCharIsSpace && !startWithSpace && !this.previousIsCarriageReturnElement) {
            data = " " + data;
        } else if (!this.lastCharIsSpace && startWithSpace && !this.previousIsCarriageReturnElement) {
            data = " " + data;
        }
        this.lastCharIsSpace = endWithSpace;
        return data;
    }

    private SpanElement getSpanElement(Document document) {
        SpanElement spanElement = document.createSpanElement();
        DOM.sinkEvents((Element)((Element)spanElement.cast()), (int)48);
        DOM.setEventListener((Element)((Element)spanElement.cast()), (EventListener)AnnotationPopupEventListener.getAnnotationPopupEventListener(this.annotation, this.controller));
        spanElement.setClassName("ignoredElement " + this.controller.getDecorateClassName() + " " + "decorate" + this.annotation.getId());
        return spanElement;
    }

    private void processToFirstNode(Node node) {
        if (node.getNodeType() != 3) {
            return;
        }
        Text text = (Text)node;
        String data = text.getData();
        if (data.length() < this.offset) {
            this.offset -= data.length();
            return;
        }
        this.decorating = true;
        Node parent = text.getParentNode();
        if (data.endsWith(" ")) {
            this.lastCharIsSpace = true;
        }
        String notInData = data.substring(0, this.offset);
        text.setData(notInData);
        this.processDecoratedNode(node, data.substring(this.offset), parent);
    }

    private void processDecoratedNode(Node node, String data, Node parent) {
        String[] selectedText = this.getSelectedText(data, this.textToAnnotate);
        if (selectedText[1].trim().length() == 0 && selectedText[2].trim().length() == 0 && node.getParentNode().getNodeName().equalsIgnoreCase("tr")) {
            this.textToAnnotate -= selectedText[0].length();
            return;
        }
        Document document = node.getOwnerDocument();
        SpanElement spanElement = this.getSpanElement(document);
        spanElement.setInnerText(selectedText[1]);
        this.insertBefore(parent, node.getNextSibling(), (Node)spanElement);
        if (selectedText[2].length() > 0) {
            this.insertBefore(parent, spanElement.getNextSibling(), (Node)document.createTextNode(selectedText[2]));
        }
        this.textToAnnotate -= selectedText[0].length();
    }

    static {
        carriagesReturnedElements.add("div");
        carriagesReturnedElements.add("br");
        carriagesReturnedElements.add("p");
    }
}

