/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view.listener;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.CSSClassManager;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater.Annotater;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater.ImageAnnotater;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater.TextAnnotater;

public class AnnotatedEventListener
implements EventListener {
    private final Annotater imageAnnotater;
    private final Annotater textAnnotater;
    private final AnnotationController controller;
    private Annotater lastUsedAnnotater = null;

    public AnnotatedEventListener(AnnotationController controller) {
        this.imageAnnotater = new ImageAnnotater(controller);
        this.textAnnotater = new TextAnnotater(controller);
        this.controller = controller;
    }

    public void onBrowserEvent(Event event) {
        if (!this.controller.canAnnotate()) {
            return;
        }
        if (event.getTarget() == null) {
            return;
        }
        if (event.getTypeInt() == 32) {
            this.manageOnMouseOutEvent(event);
            return;
        }
        if (this.isOnImage(event)) {
            this.annotateImage(event);
        } else if (!this.controller.isImageOnly()) {
            this.annotateText(event);
        }
    }

    private void manageOnMouseOutEvent(Event event) {
        if (this.lastUsedAnnotater != null) {
            this.lastUsedAnnotater.manageEvent(event);
            this.lastUsedAnnotater = null;
        }
    }

    private boolean isOnImage(Event event) {
        CSSClassManager cssManager;
        Element element = event.getTarget();
        return element.getNodeName().equalsIgnoreCase("div") ? (cssManager = new CSSClassManager(element)).isClassPresent("decorate") || cssManager.isClassPresent("decorateNot") || cssManager.isClassPresent("decorateArea") : element.getNodeName().equalsIgnoreCase("img");
    }

    private void annotateImage(Event event) {
        this.imageAnnotater.manageEvent(event);
    }

    private void annotateText(Event event) {
        this.textAnnotater.manageEvent(event);
        this.lastUsedAnnotater = this.textAnnotater;
    }
}

