/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.preview;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.platform.preview.adapter.BlobPostProcessor;

public class AnnotationBlobPostProcessor
implements BlobPostProcessor {
    private static final Log log = LogFactory.getLog(AnnotationBlobPostProcessor.class);
    protected static final int BUFFER_SIZE = 65536;
    protected static final String GWT_LOCALE = "<meta name=\"gwt:property\" content=\"locale=%s\" />";
    protected static final String ANNOTATION_MODULE_JS = "<script type=\"text/javascript\" src='/nuxeo/org.nuxeo.ecm.platform.annotations.gwt.AnnotationFrameModule/org.nuxeo.ecm.platform.annotations.gwt.AnnotationFrameModule.nocache.js'></script>";
    protected static final String INTERNET_EXPLORER_RANGE_JS = "<script type=\"text/javascript\" src='/nuxeo/scripts/InternetExplorerRange.js'></script>";
    protected Pattern headPattern = Pattern.compile("(.*)(<head>)(.*)", 34);
    protected Pattern htmlPattern = Pattern.compile("(.*)(<html>)(.*)", 34);
    protected Pattern charsetPattern = Pattern.compile("(.*) charset=(.*?)\"(.*)", 34);

    public Blob process(Blob blob) {
        String mimetype = blob.getMimeType();
        if (mimetype == null || !mimetype.startsWith("text/")) {
            return blob;
        }
        try {
            String encoding = null;
            if (blob.getEncoding() == null) {
                Matcher m = this.charsetPattern.matcher(blob.getString());
                if (m.matches()) {
                    encoding = m.group(2);
                }
            } else {
                encoding = blob.getEncoding();
            }
            String blobAsString = this.getBlobAsString(blob, encoding);
            String processedBlob = this.addAnnotationModule(blobAsString);
            byte[] bytes = encoding == null ? processedBlob.getBytes() : processedBlob.getBytes(encoding);
            blob = new ByteArrayBlob(bytes, blob.getMimeType(), encoding);
        }
        catch (IOException e) {
            log.debug((Object)"Unable to process Blob", (Throwable)e);
        }
        return blob;
    }

    protected String getBlobAsString(Blob blob, String encoding) throws IOException {
        if (encoding == null) {
            return blob.getString();
        }
        InputStreamReader reader = new InputStreamReader(blob.getStream(), encoding);
        return AnnotationBlobPostProcessor.readString(reader);
    }

    protected String addAnnotationModule(String blob) {
        LocaleSelector localeSelector = LocaleSelector.instance();
        StringBuilder sb = new StringBuilder();
        Matcher m = this.headPattern.matcher(blob);
        if (m.matches()) {
            sb.append(m.group(1));
            sb.append(m.group(2));
            if (localeSelector != null) {
                sb.append(String.format(GWT_LOCALE, localeSelector.getLocaleString()));
            }
            sb.append(INTERNET_EXPLORER_RANGE_JS);
            sb.append(ANNOTATION_MODULE_JS);
            sb.append(m.group(3));
        } else {
            m = this.htmlPattern.matcher(blob);
            if (m.matches()) {
                sb.append(m.group(1));
                sb.append(m.group(2));
                sb.append("<head>");
                if (localeSelector != null) {
                    sb.append(String.format(GWT_LOCALE, localeSelector.getLocaleString()));
                }
                sb.append(INTERNET_EXPLORER_RANGE_JS);
                sb.append(ANNOTATION_MODULE_JS);
                sb.append("</head>");
                sb.append(m.group(3));
            } else {
                log.debug((Object)"Unable to inject Annotation module javascript");
                sb.append(blob);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder(65536);
        try {
            int read;
            char[] buffer = new char[65536];
            while ((read = reader.read(buffer, 0, 65536)) != -1) {
                sb.append(buffer, 0, read);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return sb.toString();
    }
}

