/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api.adapter;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilingService;
import org.nuxeo.ecm.platform.pictures.tiles.api.adapter.PictureTilesAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.DocumentImageResource;
import org.nuxeo.ecm.platform.pictures.tiles.api.imageresource.ImageResource;
import org.nuxeo.runtime.api.Framework;

public class PictureTilesAdapterImpl
implements PictureTilesAdapter {
    protected String xPath;
    protected DocumentModel doc;
    protected String fileName;
    protected Map<String, PictureTiles> tiles = new HashMap<String, PictureTiles>();
    protected static PictureTilingService pts;

    public PictureTilesAdapterImpl(DocumentModel doc, String xPath) {
        this.xPath = xPath;
        this.doc = doc;
    }

    public PictureTilesAdapterImpl(DocumentModel doc) {
        this.xPath = null;
        this.doc = doc;
    }

    protected ImageResource getResource() {
        DocumentImageResource res = new DocumentImageResource(this.doc, this.xPath);
        if (this.fileName != null) {
            res.setFileName(this.fileName);
        }
        return res;
    }

    protected PictureTilingService getService() {
        if (pts == null) {
            pts = (PictureTilingService)Framework.getLocalService(PictureTilingService.class);
        }
        return pts;
    }

    public PictureTiles getTiles(int tileWidth, int tileHeight, int maxTiles) throws ClientException {
        String key = tileWidth + "-" + tileHeight + "-" + maxTiles;
        if (!this.tiles.containsKey(key)) {
            PictureTiles tile = this.getService().getTiles(this.getResource(), tileWidth, tileHeight, maxTiles, 0, 0, false);
            this.tiles.put(key, tile);
        }
        return this.tiles.get(key);
    }

    public void cleanup() {
        for (String k : this.tiles.keySet()) {
            this.tiles.get(k).release();
        }
        this.tiles = null;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setXPath(String path) {
        this.xPath = path;
    }

    public DocumentModel getDoc() {
        return this.doc;
    }

    public void setDoc(DocumentModel doc) {
        this.doc = doc;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

