/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.magick.tiler;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageCropperAndResizer;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilesImpl;
import org.nuxeo.ecm.platform.pictures.tiles.helpers.StringMaker;
import org.nuxeo.ecm.platform.pictures.tiles.tilers.PictureTiler;

public class MagickTiler
implements PictureTiler {
    private static final Log log = LogFactory.getLog(MagickTiler.class);

    public boolean needsSync() {
        return false;
    }

    public String getName() {
        return "MagicTiler";
    }

    int[] computeCropCoords(ImageInfo input, int maxTiles, int tileWidth, int tileHeight, int xCenter, int yCenter) {
        int startX = 0;
        int startY = 0;
        int cropWidth = 0;
        int cropHeight = 0;
        int ntx = 0;
        int nty = 0;
        if (input.getWidth() > input.getHeight()) {
            Double exactCropHeight;
            cropWidth = input.getWidth() / maxTiles;
            if (input.getWidth() % maxTiles > 0) {
                ++cropWidth;
            }
            cropHeight = (exactCropHeight = Double.valueOf(new Double(tileHeight) / (double)tileWidth * (double)cropWidth)) - (double)exactCropHeight.intValue() > 0.0 ? exactCropHeight.intValue() + 1 : exactCropHeight.intValue();
            ntx = maxTiles;
            nty = input.getHeight() / cropHeight;
            if (input.getHeight() % cropHeight > 0) {
                ++nty;
            }
        } else {
            Double exactCropWidth;
            cropHeight = input.getHeight() / maxTiles;
            if (input.getHeight() % maxTiles > 0) {
                ++cropHeight;
            }
            cropWidth = (exactCropWidth = Double.valueOf(new Double(tileWidth) / (double)tileHeight * (double)cropHeight)) - (double)exactCropWidth.intValue() > 0.0 ? exactCropWidth.intValue() + 1 : exactCropWidth.intValue();
            nty = maxTiles;
            ntx = input.getWidth() / cropWidth;
            if (input.getWidth() % cropWidth > 0) {
                ++ntx;
            }
        }
        startX = xCenter * cropWidth;
        startY = yCenter * cropHeight;
        double widthRatio = new Double(tileWidth) / (double)cropWidth;
        double heightRatio = new Double(tileHeight) / (double)cropHeight;
        if (xCenter == ntx - 1) {
            cropWidth = input.getWidth() - xCenter * cropWidth;
            tileWidth = (int)Math.round((double)cropWidth * widthRatio);
        }
        if (yCenter == nty - 1) {
            cropHeight = input.getHeight() - yCenter * cropHeight;
            tileHeight = (int)Math.round((double)cropHeight * heightRatio);
        }
        int[] result = new int[]{startX, startY, cropWidth, cropHeight, ntx, nty, tileWidth, tileHeight};
        return result;
    }

    public PictureTiles getTilesFromFile(ImageInfo input, String outputDirPath, int tileWidth, int tileHeight, int maxTiles, int xCenter, int yCenter, long lastModificationTime, boolean fullGeneration) throws ClientException {
        int[] cropCoords = this.computeCropCoords(input, maxTiles, tileWidth, tileHeight, xCenter, yCenter);
        String fileName = StringMaker.getTileFileName(xCenter, yCenter, lastModificationTime);
        String outputFilePath = new Path(outputDirPath).append(fileName).toString();
        try {
            ImageCropperAndResizer.cropAndResize((String)input.getFilePath(), (String)outputFilePath, (int)cropCoords[2], (int)cropCoords[3], (int)cropCoords[0], (int)cropCoords[1], (int)cropCoords[6], (int)cropCoords[7]);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put(PictureTilesImpl.TILE_OUTPUT_DIR_KEY, outputDirPath);
        infoMap.put(PictureTilesImpl.X_TILES_KEY, Integer.toString(cropCoords[4]));
        infoMap.put(PictureTilesImpl.Y_TILES_KEY, Integer.toString(cropCoords[5]));
        return new PictureTilesImpl(infoMap);
    }
}

