/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.serializer;

import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.serializer.PictureTilesSerializer;

public class XMLPictureTilesSerializer
implements PictureTilesSerializer {
    private static final String picturetilesNS = "http://www.nuxeo.org/picturetiles";
    private static final String picturetilesNSPrefix = "nxpt";
    private static QName rootTag = DocumentFactory.getInstance().createQName("pictureTiles", "nxpt", "http://www.nuxeo.org/picturetiles");

    protected void dumpImageInfo(ImageInfo info, Element root) {
        root.addElement("format").setText(info.getFormat());
        root.addElement("width").setText(info.getWidth() + "");
        root.addElement("height").setText(info.getHeight() + "");
    }

    public String serialize(PictureTiles tiles) {
        Element rootElem = DocumentFactory.getInstance().createElement(rootTag);
        rootElem.addNamespace(picturetilesNSPrefix, picturetilesNS);
        Document rootDoc = DocumentFactory.getInstance().createDocument(rootElem);
        Element tileInfo = rootElem.addElement("tileInfo");
        tileInfo.addElement("zoom").setText(tiles.getZoomfactor() + "");
        tileInfo.addElement("maxTiles").setText(tiles.getMaxTiles() + "");
        tileInfo.addElement("tileWidth").setText(tiles.getTilesWidth() + "");
        tileInfo.addElement("tileHeight").setText(tiles.getTilesHeight() + "");
        tileInfo.addElement("xTiles").setText(tiles.getXTiles() + "");
        tileInfo.addElement("yTiles").setText(tiles.getYTiles() + "");
        Element originalInfo = rootElem.addElement("originalImage");
        ImageInfo oInfo = tiles.getOriginalImageInfo();
        this.dumpImageInfo(oInfo, originalInfo);
        Element srcInfo = rootElem.addElement("srcImage");
        ImageInfo sInfo = tiles.getSourceImageInfo();
        this.dumpImageInfo(sInfo, srcInfo);
        Element addInfo = rootElem.addElement("additionalInfo");
        for (String k : tiles.getInfo().keySet()) {
            Element propElem = addInfo.addElement(k);
            propElem.setText(tiles.getInfo().get(k));
        }
        Element debugInfo = rootElem.addElement("debug");
        debugInfo.addElement("cacheKey").setText(tiles.getCacheKey());
        debugInfo.addElement("formatKey").setText(tiles.getTileFormatCacheKey());
        debugInfo.addElement("tilePath").setText(tiles.getTilesPath());
        return rootDoc.asXML();
    }
}

