/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingCacheGCManager;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingComponent;

public class GCTask
implements Runnable {
    public static boolean GCEnabled = false;
    private static String GCINTERVAL_KEY = "GCInterval";
    private static long GCInterval = 0L;
    private static final Log log = LogFactory.getLog(GCTask.class);

    public static long getGCIntervalInMinutes() {
        if (GCInterval == 0L) {
            GCInterval = Long.parseLong(PictureTilingComponent.getEnvValue(GCINTERVAL_KEY, Long.toString(10L)));
            log.debug((Object)("GC interval set to " + GCInterval));
        }
        return GCInterval;
    }

    public static void setGCIntervalInMinutes(long interval) {
        GCInterval = interval;
    }

    public void run() {
        log.debug((Object)"starting GC thread");
        while (GCEnabled) {
            PictureTilingCacheGCManager.gcIfNeeded();
            try {
                long gcInterval = GCTask.getGCIntervalInMinutes();
                if (gcInterval < 0L) {
                    log.debug((Object)("GC sleeps for " + -gcInterval));
                    Thread.sleep(-gcInterval);
                    continue;
                }
                log.debug((Object)("GC sleeps for " + gcInterval * 60L * 1000L));
                Thread.sleep(gcInterval * 60L * 1000L);
            }
            catch (InterruptedException e) {
                GCEnabled = false;
                log.info((Object)"GCThread bruttaly interupted");
            }
        }
    }
}

