/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.factories;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.content.template.factories.SimpleTemplateBasedFactory;
import org.nuxeo.ecm.platform.content.template.service.TemplateItemDescriptor;

public class SimpleTemplateBasedRootFactory
extends SimpleTemplateBasedFactory {
    public void createContentStructure(DocumentModel eventDoc) throws ClientException {
        super.initSession(eventDoc);
        boolean containsAlreadyContent = false;
        for (TemplateItemDescriptor item : this.template) {
            DocumentModelList existingDocsOfTheSameType = this.session.getChildren(eventDoc.getRef(), item.getTypeName());
            if (existingDocsOfTheSameType.size() == 0) {
                String itemPath = eventDoc.getPathAsString();
                if (item.getPath() != null) {
                    itemPath = itemPath + "/" + item.getPath();
                }
                DocumentModel newChild = this.session.createDocumentModel(itemPath, item.getId(), item.getTypeName());
                newChild.setProperty("dublincore", "title", (Object)item.getTitle());
                newChild.setProperty("dublincore", "description", (Object)item.getDescription());
                this.setProperties(item.getProperties(), newChild);
                newChild = this.session.createDocument(newChild);
                this.setAcl(item.getAcl(), newChild.getRef());
                continue;
            }
            containsAlreadyContent = true;
        }
        if (!containsAlreadyContent) {
            this.setAcl(this.acl, eventDoc.getRef());
        }
    }
}

