/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingConfigurationDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelector;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagingComponent
extends DefaultComponent
implements ImagingService {
    private static final Log log = LogFactory.getLog(ImagingComponent.class);
    public static final String CONFIGURATION_PARAMETERS_EP = "configuration";
    protected Map<String, String> configurationParameters = new HashMap<String, String>();
    private LibrarySelector librarySelector;

    @Deprecated
    public InputStream crop(InputStream in, int x, int y, int width, int height) {
        try {
            return this.getLibrarySelectorService().getImageUtils().crop(in, x, y, width, height);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return in;
    }

    @Deprecated
    public InputStream resize(InputStream in, int width, int height) {
        try {
            return this.getLibrarySelectorService().getImageUtils().resize(in, width, height);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return in;
    }

    @Deprecated
    public InputStream rotate(InputStream in, int angle) {
        try {
            return this.getLibrarySelectorService().getImageUtils().rotate(in, angle);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return in;
    }

    public Blob crop(Blob blob, int x, int y, int width, int height) {
        try {
            return this.getLibrarySelectorService().getImageUtils().crop(blob, x, y, width, height);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return blob;
    }

    public Blob resize(Blob blob, String finalFormat, int width, int height, int depth) {
        try {
            return this.getLibrarySelectorService().getImageUtils().resize(blob, finalFormat, width, height, depth);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return blob;
    }

    public Blob rotate(Blob blob, int angle) {
        try {
            return this.getLibrarySelectorService().getImageUtils().rotate(blob, angle);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageUtils Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return blob;
    }

    @Deprecated
    public Map<String, Object> getImageMetadata(InputStream in) {
        try {
            return this.getLibrarySelectorService().getMetadataUtils().getImageMetadata(in);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageMetadata Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageMetadata Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    @Deprecated
    public Map<String, Object> getImageMetadata(File file) {
        try {
            return this.getLibrarySelectorService().getMetadataUtils().getImageMetadata(file);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageMetadata Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageMetadata Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public Map<String, Object> getImageMetadata(Blob blob) {
        try {
            return this.getLibrarySelectorService().getMetadataUtils().getImageMetadata(blob);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageMetadata Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageMetadata Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public String getImageMimeType(File file) {
        try {
            return this.getLibrarySelectorService().getMimeUtils().getImageMimeType(file);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageMime Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageMime Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    public String getImageMimeType(InputStream in) {
        try {
            return this.getLibrarySelectorService().getMimeUtils().getImageMimeType(in);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instanciate ImageMime Class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instanciate ImageMime Class", (Throwable)e);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
        }
        return null;
    }

    private LibrarySelector getLibrarySelectorService() throws ClientException {
        if (this.librarySelector == null) {
            this.librarySelector = (LibrarySelector)Framework.getRuntime().getService(LibrarySelector.class);
        }
        if (this.librarySelector == null) {
            log.error((Object)"Unable to get LibrarySelector runtime service");
            throw new ClientException("Unable to get LibrarySelector runtime service");
        }
        return this.librarySelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo getImageInfo(Blob blob) {
        ImageInfo imageInfo = null;
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), blob.getFilename() != null ? blob.getFilename() : "tmp.tmp");
        try {
            blob.transferTo(tmpFile);
            imageInfo = ImageIdentifier.getInfo(tmpFile.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)("Failed to get the ImageInfo for file" + blob.getFilename()), (Throwable)e);
        }
        finally {
            tmpFile.delete();
        }
        return imageInfo;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIGURATION_PARAMETERS_EP.equals(extensionPoint)) {
            ImagingConfigurationDescriptor desc = (ImagingConfigurationDescriptor)contribution;
            this.configurationParameters.putAll(desc.getParameters());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CONFIGURATION_PARAMETERS_EP.equals(extensionPoint)) {
            ImagingConfigurationDescriptor desc = (ImagingConfigurationDescriptor)contribution;
            for (String configuration : desc.getParameters().keySet()) {
                this.configurationParameters.remove(configuration);
            }
        }
    }

    public String getConfigurationValue(String configurationName) {
        return this.configurationParameters.get(configurationName);
    }

    public String getConfigurationValue(String configurationName, String defaultValue) {
        return this.configurationParameters.containsKey(configurationName) ? this.configurationParameters.get(configurationName) : defaultValue;
    }

    public void setConfigurationValue(String configurationName, String configurationValue) {
        this.configurationParameters.put(configurationName, configurationValue);
    }
}

