/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.imagej;

import ij.ImagePlus;
import ij.io.Opener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.platform.picture.core.MimeUtils;

public class ImageJMimeUtils
implements MimeUtils {
    private static final Log log = LogFactory.getLog(ImageJMimeUtils.class);

    public String getImageMimeType(File file) {
        Opener op = new Opener();
        ImagePlus im = op.openImage(file.getPath());
        if (im == null) {
            return null;
        }
        int fileType = im.getOriginalFileInfo().fileFormat;
        return this.getInternalMimeType(fileType);
    }

    public String getImageMimeType(InputStream in) {
        FileBlob fb;
        try {
            fb = new FileBlob(in);
        }
        catch (IOException e) {
            log.error((Object)"Can't find the file", (Throwable)e);
            return "";
        }
        String path = fb.getFile().getPath();
        Opener op = new Opener();
        ImagePlus im = op.openImage(path);
        if (im == null) {
            return null;
        }
        int fileType = im.getOriginalFileInfo().fileFormat;
        return this.getInternalMimeType(fileType);
    }

    private String getInternalMimeType(int fileType) {
        if (fileType == 5) {
            return "image/jpeg";
        }
        if (fileType == 8) {
            return "image/bmp";
        }
        if (fileType == 13) {
            return "image/png";
        }
        if (fileType == 6) {
            return "image/gif";
        }
        if (fileType == 1) {
            return "image/tiff";
        }
        if (fileType == 14) {
            return "image/tiff";
        }
        if (fileType == 3) {
            return "image/fits";
        }
        if (fileType == 4) {
            return "image/x-portable-graymap";
        }
        if (fileType == 9) {
            return "application/zip";
        }
        return "application/octet-stream";
    }
}

