/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.libraryselector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.ecm.platform.picture.core.MetadataUtils;
import org.nuxeo.ecm.platform.picture.core.MimeUtils;
import org.nuxeo.ecm.platform.picture.core.libraryselector.ImageUtilsDescriptor;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelector;
import org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelectorServiceDescriptor;
import org.nuxeo.ecm.platform.picture.core.libraryselector.MetadataUtilsDescriptor;
import org.nuxeo.ecm.platform.picture.core.libraryselector.MimeUtilsDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class LibrarySelectorService
extends DefaultComponent
implements LibrarySelector {
    public static final String NAME = "org.nuxeo.ecm.platform.picture.core.libraryselector.LibrarySelectorService";
    public static final String LIBRARY_SELECTOR = "LibrarySelector";
    private static final Log log = LogFactory.getLog(LibrarySelectorService.class);
    private static ImageUtilsDescriptor imageUtilsDescriptor;
    private static MetadataUtilsDescriptor metadataUtilsDescriptor;
    private static MimeUtilsDescriptor mimeUtilsDescriptor;

    public void activate(ComponentContext context) {
    }

    public void deactivate(ComponentContext context) {
        imageUtilsDescriptor = null;
        metadataUtilsDescriptor = null;
        mimeUtilsDescriptor = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(LIBRARY_SELECTOR)) {
            LibrarySelectorServiceDescriptor libraryDesc = (LibrarySelectorServiceDescriptor)contribution;
            LibrarySelectorService.registerPictureAdapter(libraryDesc, contributor);
        } else {
            log.error((Object)("Extension point " + extensionPoint + "is unknown"));
        }
    }

    public static void registerPictureAdapter(LibrarySelectorServiceDescriptor libraryDesc, ComponentInstance contributor) {
        imageUtilsDescriptor = libraryDesc.getImageUtils();
        mimeUtilsDescriptor = libraryDesc.getMimeUtils();
        metadataUtilsDescriptor = libraryDesc.getMetadataUtils();
        log.debug((Object)("Using " + imageUtilsDescriptor.getName() + " for ImageUtils.\n" + "Using " + mimeUtilsDescriptor.getName() + " for MimeUtils.\n" + "Using " + metadataUtilsDescriptor.getName() + " for MeadataUtils.\n"));
    }

    public ImageUtils getImageUtils() throws InstantiationException, IllegalAccessException {
        return imageUtilsDescriptor.getNewInstance();
    }

    public MimeUtils getMimeUtils() throws InstantiationException, IllegalAccessException {
        return mimeUtilsDescriptor.getNewInstance();
    }

    public MetadataUtils getMetadataUtils() throws InstantiationException, IllegalAccessException {
        return metadataUtilsDescriptor.getNewInstance();
    }
}

