/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.extension;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;

public class ImagePlugin
extends AbstractFileImporter {
    private static final long serialVersionUID = 5850210255138418118L;
    private static final Log log = LogFactory.getLog(ImagePlugin.class);

    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws ClientException, IOException {
        DocumentModel docModel;
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        String title = FileManagerUtils.fetchTitle((String)filename);
        DocumentModel existing = FileManagerUtils.getExistingDocByTitle((CoreSession)documentManager, (String)path, (String)title);
        if (overwrite && existing != null) {
            docModel = existing;
            DocumentRef docRef = docModel.getRef();
            VersionModelImpl newVersion = new VersionModelImpl();
            newVersion.setLabel(documentManager.generateVersionLabelFor(docRef));
            documentManager.checkIn(docRef, (VersionModel)newVersion);
            documentManager.checkOut(docRef);
            ((Map)((List)docModel.getDataModel("picture").getData("views")).get(0)).put("content", content.persist());
        } else {
            String docId = IdUtils.generateId((String)title);
            DocumentModelImpl document = new DocumentModelImpl(path, docId, "Picture");
            docModel = documentManager.createDocument((DocumentModel)document);
            try {
                DocumentModel parent = documentManager.getDocument(docModel.getParentRef());
                ArrayList pictureTemplates = null;
                if (parent.getType().equals("PictureBook")) {
                    pictureTemplates = (ArrayList)parent.getProperty("picturebook", "picturetemplates");
                }
                PictureResourceAdapter picture = (PictureResourceAdapter)docModel.getAdapter(PictureResourceAdapter.class);
                picture.createPicture(content, filename, title, pictureTemplates);
            }
            catch (Exception e) {
                log.error((Object)"Picture.views generation failed", (Throwable)e);
            }
            Type imageType = typeService.getType("Picture");
            if (imageType != null) {
                String iconPath = imageType.getIcon();
                docModel.setProperty("common", "icon", (Object)iconPath);
            }
        }
        documentManager.saveDocument(docModel);
        documentManager.save();
        log.debug((Object)("Created the Picture: " + docModel.getName() + " with icon : " + docModel.getProperty("common", "icon")));
        return docModel;
    }
}

