/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.CoreSessionFactory;
import org.nuxeo.ecm.core.api.repository.DocumentProvider;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.repository.impl.DocumentProviderManager;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CoreInstance.class);
    private static final CoreInstance instance = new CoreInstance();
    private CoreSessionFactory factory;
    private final Map<String, CoreSession> sessions = new ConcurrentHashMap<String, CoreSession>();
    private final Map<String, DocumentType> docTypes = new Hashtable<String, DocumentType>();
    private final Map<String, DocumentProvider> documentProviders = new Hashtable<String, DocumentProvider>();

    protected CoreInstance() {
    }

    public static CoreInstance getInstance() {
        return instance;
    }

    public DocumentType getCachedDocumentType(String type) {
        return this.docTypes.get(type);
    }

    public void cacheDocumentType(DocumentType docType) {
        this.docTypes.put(docType.getName(), docType);
    }

    public CoreSession open(String repositoryName, Map<String, Serializable> context) throws ClientException {
        try {
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            CoreSession session = null;
            if (rm != null) {
                Repository repo = rm.getRepository(repositoryName);
                if (repo == null) {
                    throw new ClientException("No such repository: " + repositoryName);
                }
                session = repo.open(context);
            }
            if (session == null) {
                session = this.compatOpen(repositoryName, context);
            }
            return session;
        }
        catch (Exception e) {
            throw new ClientException("Failed to intialize core session on repository " + repositoryName, e);
        }
    }

    @Deprecated
    private CoreSession compatOpen(String repositoryName, Map<String, Serializable> context) throws ClientException {
        CoreSession client = this.factory.getSession();
        client.connect(repositoryName, context);
        this.sessions.put(client.getSessionId(), client);
        return client;
    }

    public void registerSession(String sid, CoreSession session) {
        this.sessions.put(sid, session);
    }

    public CoreSession unregisterSession(String sid) {
        return this.sessions.remove(sid);
    }

    public void close(CoreSession client) {
        if ((client = this.sessions.remove(client.getSessionId())) != null) {
            client.destroy();
        } else {
            log.warn((Object)"Trying to close a non referenced CoreSession (destroy method won't be called)");
        }
    }

    public boolean isSessionStarted(String sid) {
        return this.sessions.containsKey(sid);
    }

    @Deprecated
    public CoreSession[] getSessions() {
        Collection<CoreSession> valuesOfMap = this.sessions.values();
        return valuesOfMap.toArray(new CoreSession[0]);
    }

    public CoreSession getSession(String sid) {
        return this.sessions.get(sid);
    }

    public void initialize(CoreSessionFactory factory) {
        CoreInstance.instance.factory = factory;
    }

    public CoreSessionFactory getFactory() {
        return this.factory;
    }

    public DocumentProvider getDocumentProvider(String sid) {
        CoreSession session;
        DocumentProvider documentProvider = this.documentProviders.get(sid);
        if (documentProvider == null && (session = this.getSession(sid)) != null) {
            documentProvider = (DocumentProvider)Framework.getLocalService(DocumentProvider.class);
            if (documentProvider instanceof DocumentProviderManager) {
                ((DocumentProviderManager)documentProvider).setSession(session);
            }
            this.documentProviders.put(sid, documentProvider);
        }
        return documentProvider;
    }
}

