/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ArrayMap;
import org.nuxeo.common.collections.PrimitiveArrays;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.common.utils.Null;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DataModelMap;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterDescriptor;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterService;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DataModelMapImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.TypeService;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.JavaTypes;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModelImpl
implements DocumentModel,
Cloneable {
    public static final String STRICT_LAZY_LOADING_POLICY_KEY = "org.nuxeo.ecm.core.strictlazyloading";
    public static final long F_STORED = 1L;
    public static final long F_DETACHED = 2L;
    public static final long F_VERSION = 16L;
    public static final long F_PROXY = 32L;
    public static final long F_LOCKED = 64L;
    public static final long F_DIRTY = 128L;
    private static final long serialVersionUID = 4473357367146978325L;
    private static final Log log = LogFactory.getLog(DocumentModelImpl.class);
    protected String sid;
    protected DocumentRef ref;
    protected TypeRef<DocumentType> type;
    protected String[] declaredSchemas;
    protected Set<String> declaredFacets;
    protected String id;
    protected Path path;
    protected DataModelMap dataModels;
    protected DocumentRef parentRef;
    protected String lock;
    protected transient ACP acp;
    protected transient boolean isACPLoaded = false;
    protected transient ArrayMap<Class, Object> adapters;
    protected long flags = 0L;
    protected String repositoryName;
    protected String sourceId;
    private ScopedMap contextData;
    protected HashMap<String, Serializable> prefetch;
    private String currentLifeCycleState;
    private String lifeCyclePolicy;
    protected static Boolean strictSessionManagement = null;

    protected DocumentModelImpl() {
    }

    public DocumentModelImpl(String type) {
        this.type = new TypeRef("@doctypes", type);
        this.dataModels = new DataModelMapImpl();
        this.contextData = new ScopedMap();
    }

    public DocumentModelImpl(String sid, String type) {
        this(type);
        this.sid = sid;
    }

    public DocumentModelImpl(String parentPath, String name, String type) {
        this(parentPath, name, type, null);
    }

    public DocumentModelImpl(DocumentModel parent, String name, String type) {
        this(parent.getPathAsString(), name, type, null);
    }

    public DocumentModelImpl(DocumentModel parent, String name, String type, DataModelMap data) {
        this(parent.getPathAsString(), name, type, data);
    }

    public DocumentModelImpl(String parentPath, String name, String type, DataModelMap data) {
        this.path = new Path(parentPath + '/' + name);
        this.type = new TypeRef("@doctypes", type);
        this.ref = new PathRef(parentPath, name);
        this.dataModels = data == null ? new DataModelMapImpl() : data;
        this.contextData = new ScopedMap();
    }

    public DocumentModelImpl(String sid, String type, String id, Path path, DocumentRef docRef, DocumentRef parentRef, String[] schemas, Set<String> facets) {
        this(sid, type, id, path, null, docRef, parentRef, schemas, facets);
    }

    @Deprecated
    public DocumentModelImpl(String sid, String type, String id, Path path, String lock, DocumentRef docRef, DocumentRef parentRef, String[] schemas, Set<String> facets) {
        this.sid = sid;
        this.type = new TypeRef("@doctypes", type);
        this.id = id;
        this.path = path;
        this.ref = docRef;
        this.parentRef = parentRef;
        this.declaredSchemas = schemas;
        this.declaredFacets = facets;
        this.dataModels = new DataModelMapImpl();
        this.lock = lock;
        this.contextData = new ScopedMap();
    }

    public DocumentModelImpl(String sid, String type, String id, Path path, String lock, DocumentRef docRef, DocumentRef parentRef, String[] schemas, Set<String> facets, String sourceId, String repositoryName) {
        this.sid = sid;
        this.type = new TypeRef("@doctypes", type);
        this.id = id;
        this.path = path;
        this.ref = docRef;
        this.parentRef = parentRef;
        this.declaredSchemas = schemas;
        this.declaredFacets = facets;
        this.dataModels = new DataModelMapImpl();
        this.lock = lock;
        this.contextData = new ScopedMap();
        this.repositoryName = repositoryName;
        this.sourceId = sourceId;
    }

    @Override
    public DocumentType getDocumentType() {
        return (DocumentType)this.type.get();
    }

    @Override
    public String getTitle() throws ClientException {
        String title = (String)this.getProperty("dublincore", "title");
        if (title != null) {
            return title;
        }
        title = this.getName();
        if (title != null) {
            return title;
        }
        return this.id;
    }

    @Override
    public String getSessionId() {
        return this.sid;
    }

    @Override
    public DocumentRef getRef() {
        return this.ref;
    }

    @Override
    public DocumentRef getParentRef() {
        if (this.parentRef == null && this.path != null) {
            Path parentPath = this.path.removeLastSegments(1);
            this.parentRef = new PathRef(parentPath.toString());
        }
        return this.parentRef;
    }

    @Override
    public CoreSession getCoreSession() {
        if (this.sid == null) {
            return null;
        }
        return CoreInstance.getInstance().getSession(this.sid);
    }

    protected boolean useStrictSessionManagement() {
        if (strictSessionManagement == null) {
            strictSessionManagement = Boolean.parseBoolean(Framework.getProperty((String)STRICT_LAZY_LOADING_POLICY_KEY, (String)"false"));
        }
        return strictSessionManagement;
    }

    protected CoreSession getTempCoreSession() throws ClientException {
        CoreSession tempSession;
        if (this.sid != null && this.useStrictSessionManagement()) {
            throw new ClientException("Document " + this.id + " is bound to a closed CoreSession, can not reconnect");
        }
        try {
            RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
            Repository repo = mgr.getRepository(this.repositoryName);
            tempSession = repo.open();
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        return tempSession;
    }

    @Deprecated
    public final CoreSession getClient() throws ClientException {
        if (this.sid == null) {
            throw new UnsupportedOperationException("Cannot load data models for client defined models");
        }
        CoreSession session = CoreInstance.getInstance().getSession(this.sid);
        if (session == null && this.sid != null && this.repositoryName != null) {
            try {
                RepositoryManager mgr = (RepositoryManager)Framework.getService(RepositoryManager.class);
                Repository repo = mgr.getRepository(this.repositoryName);
                session = repo.open();
                this.sid = session.getSessionId();
            }
            catch (Exception e) {
                throw new ClientException(e);
            }
        }
        return session;
    }

    public void detach(boolean loadAll) throws ClientException {
        DocumentType dt;
        if (this.sid == null) {
            return;
        }
        if (loadAll && this.type != null && (dt = (DocumentType)this.type.get()) != null) {
            for (String schema : dt.getSchemaNames()) {
                if (this.isSchemaLoaded(schema)) continue;
                this.loadDataModel(schema);
            }
        }
        if (this.ref != null) {
            this.getACP();
        }
        this.sid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataModel loadDataModel(String schema) throws ClientException {
        if (this.hasSchema(schema)) {
            if (this.sid == null) {
                DataModelImpl dataModel = new DataModelImpl(schema);
                this.dataModels.put(schema, dataModel);
                return dataModel;
            }
            CoreSession session = this.getCoreSession();
            DataModel dataModel = null;
            if (this.ref != null) {
                if (session != null) {
                    dataModel = session.getDataModel(this.ref, schema);
                } else if (this.useStrictSessionManagement()) {
                    log.warn((Object)("DocumentModel " + this.id + " is bound to a null or closed session : lazy loading is not available"));
                } else {
                    CoreSession tmpSession = this.getTempCoreSession();
                    try {
                        dataModel = tmpSession.getDataModel(this.ref, schema);
                    }
                    finally {
                        if (tmpSession != null) {
                            CoreInstance.getInstance().close(tmpSession);
                        }
                    }
                }
                this.dataModels.put(schema, dataModel);
            }
            return dataModel;
        }
        return null;
    }

    @Override
    public DataModel getDataModel(String schema) throws ClientException {
        DataModel dataModel = (DataModel)this.dataModels.get(schema);
        if (dataModel == null) {
            dataModel = this.loadDataModel(schema);
        }
        return dataModel;
    }

    @Override
    public Collection<DataModel> getDataModelsCollection() {
        return this.dataModels.values();
    }

    public void addDataModel(DataModel dataModel) {
        this.dataModels.put(dataModel.getSchema(), dataModel);
    }

    @Override
    public String[] getDeclaredSchemas() {
        return this.declaredSchemas;
    }

    @Override
    public Set<String> getDeclaredFacets() {
        return this.declaredFacets;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        if (this.path != null) {
            return this.path.lastSegment();
        }
        return null;
    }

    @Override
    public String getPathAsString() {
        if (this.path != null) {
            return this.path.toString();
        }
        return null;
    }

    @Override
    public Map<String, Object> getProperties(String schemaName) throws ClientException {
        DataModel dm = this.getDataModel(schemaName);
        return dm == null ? null : dm.getMap();
    }

    @Override
    public Object getProperty(String schemaName, String name) throws ClientException {
        DataModel dm = (DataModel)this.dataModels.get(schemaName);
        if (dm == null) {
            Serializable value;
            if (this.prefetch != null && (value = this.prefetch.get(schemaName + '.' + name)) != null) {
                return value == Null.VALUE ? null : value;
            }
            dm = this.getDataModel(schemaName);
        }
        return dm == null ? null : dm.getData(name);
    }

    @Override
    public void setPathInfo(String parentPath, String name) {
        this.path = new Path(parentPath + '/' + name);
        this.ref = new PathRef(parentPath, name);
    }

    @Override
    public String getLock() {
        return this.lock;
    }

    @Override
    public boolean isLocked() {
        return this.lock != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLock(String key) throws ClientException {
        CoreSession session = this.getCoreSession();
        if (session != null) {
            session.setLock(this.ref, key);
        } else {
            CoreSession tmpSession = this.getTempCoreSession();
            try {
                tmpSession.setLock(this.ref, key);
            }
            finally {
                if (tmpSession != null) {
                    try {
                        tmpSession.save();
                    }
                    finally {
                        CoreInstance.getInstance().close(tmpSession);
                    }
                }
            }
        }
        this.lock = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() throws ClientException {
        CoreSession session = this.getCoreSession();
        if (session != null) {
            if (session.unlock(this.ref) != null) {
                this.lock = null;
            }
        } else {
            CoreSession tmpSession = this.getTempCoreSession();
            try {
                if (tmpSession.unlock(this.ref) != null) {
                    this.lock = null;
                }
            }
            finally {
                if (tmpSession != null) {
                    try {
                        tmpSession.save();
                    }
                    finally {
                        CoreInstance.getInstance().close(tmpSession);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ACP getACP() throws ClientException {
        if (!this.isACPLoaded) {
            CoreSession session = this.getCoreSession();
            if (session != null) {
                this.acp = session.getACP(this.ref);
            } else {
                CoreSession tmpSession = this.getTempCoreSession();
                try {
                    this.acp = tmpSession.getACP(this.ref);
                }
                finally {
                    if (tmpSession != null) {
                        CoreInstance.getInstance().close(tmpSession);
                    }
                }
            }
            this.isACPLoaded = true;
        }
        return this.acp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setACP(ACP acp, boolean overwrite) throws ClientException {
        CoreSession session = this.getCoreSession();
        if (session != null) {
            session.setACP(this.ref, acp, overwrite);
        } else {
            CoreSession tmpSession = this.getTempCoreSession();
            try {
                tmpSession.setACP(this.ref, acp, overwrite);
            }
            finally {
                if (tmpSession != null) {
                    try {
                        tmpSession.save();
                    }
                    finally {
                        CoreInstance.getInstance().close(tmpSession);
                    }
                }
            }
        }
        this.isACPLoaded = false;
    }

    @Override
    public String getType() {
        return this.type != null ? this.type.getName() : null;
    }

    @Override
    public void setProperties(String schemaName, Map<String, Object> data) throws ClientException {
        DataModel dm = this.getDataModel(schemaName);
        if (dm != null) {
            dm.setMap(data);
        }
    }

    @Override
    public void setProperty(String schemaName, String name, Object value) throws ClientException {
        DataModel dm = this.getDataModel(schemaName);
        if (dm != null) {
            dm.setData(name, value);
        }
    }

    @Override
    public boolean hasSchema(String schema) {
        if (this.type == null) {
            return false;
        }
        DocumentType dt = (DocumentType)this.type.get();
        return dt == null ? false : dt.hasSchema(schema);
    }

    @Override
    public boolean hasFacet(String facet) {
        if (this.declaredFacets != null) {
            return this.declaredFacets.contains(facet);
        }
        return false;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public DataModelMap getDataModels() {
        return this.dataModels;
    }

    public void copyContentInto(DocumentModelImpl other) {
        other.declaredSchemas = this.declaredSchemas;
        other.declaredFacets = this.declaredFacets;
        other.dataModels = this.dataModels;
    }

    @Override
    public boolean isFolder() {
        return this.hasFacet("Folderish");
    }

    @Override
    public boolean isVersionable() {
        return this.hasFacet("Versionable");
    }

    @Override
    public boolean isDownloadable() throws ClientException {
        Long size;
        if (this.hasFacet("Downloadable") && (size = (Long)this.getProperty("common", "size")) != null) {
            return size != 0L;
        }
        return false;
    }

    @Override
    public <T> T getAdapter(Class<T> itf) {
        Object facet = this.getAdapters().get(itf);
        if (facet == null && (facet = this.findAdapter(itf)) != null) {
            this.adapters.put(itf, facet);
        }
        return (T)facet;
    }

    private ArrayMap<Class, Object> getAdapters() {
        if (this.adapters == null) {
            this.adapters = new ArrayMap();
        }
        return this.adapters;
    }

    @Override
    public <T> T getAdapter(Class<T> itf, boolean refreshCache) {
        T facet = !refreshCache ? this.getAdapter(itf) : this.findAdapter(itf);
        if (facet != null) {
            this.getAdapters().put(itf, facet);
        }
        return facet;
    }

    private <T> T findAdapter(Class<T> itf) {
        DocumentAdapterService svc = (DocumentAdapterService)((Object)Framework.getRuntime().getComponent(DocumentAdapterService.NAME));
        if (svc != null) {
            DocumentAdapterDescriptor dae = svc.getAdapterDescriptor(itf);
            if (dae != null) {
                String facet = dae.getFacet();
                if (facet == null) {
                    return (T)dae.getFactory().getAdapter(this, itf);
                }
                if (this.hasFacet(facet)) {
                    return (T)dae.getFactory().getAdapter(this, itf);
                }
                log.error((Object)("Document model cannot be adapted to " + itf + " because it has no facet " + facet));
            }
        } else {
            log.warn((Object)("DocumentAdapterService not available. Cannot get document model adaptor for " + itf));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean followTransition(String transition) throws ClientException {
        CoreSession session = this.getCoreSession();
        boolean res = false;
        if (session != null) {
            res = session.followTransition(this.ref, transition);
        } else {
            CoreSession tmpSession = this.getTempCoreSession();
            try {
                res = tmpSession.followTransition(this.ref, transition);
            }
            finally {
                if (tmpSession != null) {
                    try {
                        tmpSession.save();
                    }
                    finally {
                        CoreInstance.getInstance().close(tmpSession);
                    }
                }
            }
        }
        if (res) {
            this.currentLifeCycleState = null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAllowedStateTransitions() throws ClientException {
        Collection<Object> allowedStateTransitions = new ArrayList();
        CoreSession session = this.getCoreSession();
        if (session != null) {
            allowedStateTransitions = session.getAllowedStateTransitions(this.ref);
        } else {
            CoreSession tmpSession = this.getTempCoreSession();
            try {
                allowedStateTransitions = tmpSession.getAllowedStateTransitions(this.ref);
            }
            finally {
                if (tmpSession != null) {
                    CoreInstance.getInstance().close(tmpSession);
                }
            }
        }
        return allowedStateTransitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentLifeCycleState() throws ClientException {
        if (this.currentLifeCycleState != null) {
            return this.currentLifeCycleState;
        }
        if (this.sid == null) {
            return null;
        }
        CoreSession session = this.getCoreSession();
        if (session != null) {
            this.currentLifeCycleState = session.getCurrentLifeCycleState(this.ref);
        } else {
            CoreSession tmpSession = this.getTempCoreSession();
            try {
                this.currentLifeCycleState = tmpSession.getCurrentLifeCycleState(this.ref);
            }
            finally {
                if (tmpSession != null) {
                    CoreInstance.getInstance().close(tmpSession);
                }
            }
        }
        return this.currentLifeCycleState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLifeCyclePolicy() throws ClientException {
        if (this.lifeCyclePolicy != null) {
            return this.lifeCyclePolicy;
        }
        CoreSession session = this.getCoreSession();
        if (session != null) {
            this.lifeCyclePolicy = session.getLifeCyclePolicy(this.ref);
        } else {
            CoreSession tmpSession = this.getTempCoreSession();
            try {
                this.lifeCyclePolicy = tmpSession.getLifeCyclePolicy(this.ref);
            }
            finally {
                if (tmpSession != null) {
                    CoreInstance.getInstance().close(tmpSession);
                }
            }
        }
        return this.lifeCyclePolicy;
    }

    @Override
    public boolean isVersion() {
        return (this.flags & 0x10L) != 0L;
    }

    @Override
    public boolean isProxy() {
        return (this.flags & 0x20L) != 0L;
    }

    public void setIsVersion(boolean isVersion) {
        this.flags = isVersion ? (this.flags |= 0x10L) : (this.flags &= 0xFFFFFFFFFFFFFFEFL);
    }

    public void setIsProxy(boolean isProxy) {
        this.flags = isProxy ? (this.flags |= 0x20L) : (this.flags &= 0xFFFFFFFFFFFFFFDFL);
    }

    @Override
    public ScopedMap getContextData() {
        return this.contextData;
    }

    @Override
    public Serializable getContextData(ScopeType scope, String key) {
        return this.contextData.getScopedValue(scope, key);
    }

    @Override
    public void putContextData(ScopeType scope, String key, Serializable value) {
        this.contextData.putScopedValue(scope, key, value);
    }

    @Override
    public Serializable getContextData(String key) {
        return this.contextData.getScopedValue(key);
    }

    @Override
    public void putContextData(String key, Serializable value) {
        this.contextData.putScopedValue(key, value);
    }

    @Override
    public void copyContextData(DocumentModel otherDocument) {
        ScopedMap otherMap = otherDocument.getContextData();
        if (otherMap != null) {
            this.contextData.putAll((Map)otherMap);
        }
    }

    @Override
    public void copyContent(DocumentModel sourceDoc) throws ClientException {
        String[] schemas = sourceDoc.getDeclaredSchemas();
        this.declaredSchemas = schemas == null ? null : (String[])schemas.clone();
        Set<String> facets = sourceDoc.getDeclaredFacets();
        this.declaredFacets = facets == null ? null : new HashSet<String>(facets);
        DataModelMapImpl newDataModels = new DataModelMapImpl();
        for (String key : sourceDoc.getDocumentType().getSchemaNames()) {
            DataModel oldDM = sourceDoc.getDataModel(key);
            DataModel newDM = this.cloneDataModel(oldDM);
            newDataModels.put(key, newDM);
        }
        this.dataModels = newDataModels;
    }

    public static Object cloneField(Field field, String key, Object value) {
        Object clone;
        Type type = field.getType();
        if (type.isSimpleType()) {
            if (value instanceof Calendar) {
                Calendar newValue = (Calendar)((Object)value);
                clone = newValue.clone();
            } else {
                clone = value;
            }
        } else if (type.isListType()) {
            ListType ltype = (ListType)type;
            Field lfield = ltype.getField();
            Type ftype = lfield.getType();
            List<Object> list = value instanceof Object[] ? Arrays.asList((Object[])value) : (List<Object>)((Object)value);
            if (ftype.isComplexType()) {
                Object[] clonedList = new ArrayList(list.size());
                for (Object o : list) {
                    clonedList.add(DocumentModelImpl.cloneField(lfield, null, o));
                }
                clone = clonedList;
            } else {
                Class klass = JavaTypes.getClass((Type)ftype);
                clone = klass.isPrimitive() ? PrimitiveArrays.toPrimitiveArray(list, (Class)klass) : list.toArray((Object[])Array.newInstance(klass, list.size()));
            }
        } else {
            ComplexType ctype = (ComplexType)type;
            if (TypeConstants.isContentType((Type)ctype)) {
                Blob blob = (Blob)((Object)value);
                clone = blob;
            } else {
                Map map = value;
                HashMap<String, Object> clonedMap = new HashMap<String, Object>();
                for (Map.Entry entry : map.entrySet()) {
                    Object v = entry.getValue();
                    String k = (String)entry.getKey();
                    if (v == null) continue;
                    clonedMap.put(k, DocumentModelImpl.cloneField(ctype.getField(k), k, v));
                }
                clone = clonedMap;
            }
        }
        return clone;
    }

    public static DataModel cloneDataModel(Schema schema, DataModel data) {
        DataModelImpl dm = new DataModelImpl(schema.getName());
        for (Field field : schema.getFields()) {
            Object value;
            String key = field.getName().getLocalName();
            try {
                value = data.getData(key);
            }
            catch (PropertyException e1) {
                continue;
            }
            if (value == null) continue;
            Object clone = DocumentModelImpl.cloneField(field, key, value);
            try {
                dm.setData(key, clone);
            }
            catch (PropertyException e) {
                throw new ClientRuntimeException(e);
            }
        }
        return dm;
    }

    public DataModel cloneDataModel(DataModel data) {
        SchemaManager mgr = TypeService.getSchemaManager();
        return DocumentModelImpl.cloneDataModel(mgr.getSchema(data.getSchema()), data);
    }

    @Override
    public String getCacheKey() throws ClientException {
        String key = this.id + '-' + this.sid + '-' + this.getPathAsString();
        Calendar timeStamp = (Calendar)this.getProperty("dublincore", "modified");
        if (timeStamp != null) {
            key = key + '-' + String.valueOf(timeStamp.getTimeInMillis());
        }
        return key;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public String getSourceId() {
        return this.sourceId;
    }

    @Override
    public String getVersionLabel() {
        return (String)((Object)this.contextData.getScopedValue("version.label"));
    }

    public boolean isSchemaLoaded(String name) {
        return this.dataModels.containsKey(name);
    }

    @Override
    public void prefetchProperty(String id, Object value) {
        if (this.prefetch == null) {
            this.prefetch = new HashMap();
        }
        Serializable sValue = (Serializable)value;
        this.prefetch.put(id, (Serializable)(value == null ? Null.VALUE : sValue));
    }

    @Override
    public void prefetchCurrentLifecycleState(String lifecycle) {
        this.currentLifeCycleState = lifecycle;
    }

    @Override
    public void prefetchLifeCyclePolicy(String lifeCyclePolicy) {
        this.lifeCyclePolicy = lifeCyclePolicy;
    }

    public void setFlags(long flags) {
        this.flags |= flags;
    }

    public void clearFlags(long flags) {
        this.flags &= flags ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void clearFlags() {
        this.flags = 0L;
    }

    @Override
    public long getFlags() {
        return this.flags;
    }

    public boolean hasFlags(long flags) {
        return (this.flags & flags) == flags;
    }

    public boolean equals(Object obj) {
        DocumentModel documentModel;
        String id;
        if (obj == this) {
            return true;
        }
        if (obj instanceof DocumentModelImpl && (id = (documentModel = (DocumentModel)obj).getId()) != null) {
            return id.equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(DocumentModelImpl.class.getSimpleName());
        buf.append(" {");
        buf.append(" -title: ");
        try {
            buf.append(this.getProperty("dublincore", "title"));
        }
        catch (ClientException e) {
            buf.append("ERROR GETTING THE TITLE: " + e);
        }
        buf.append(", sessionId: ");
        buf.append(this.sid);
        buf.append(", doc id: ");
        buf.append(this.id);
        buf.append(", name: ");
        buf.append(this.getName());
        buf.append(", path: ");
        buf.append(this.path);
        buf.append(", ref: ");
        buf.append(this.ref);
        buf.append(", parent ref: ");
        buf.append(this.getParentRef());
        buf.append(", data models: ");
        buf.append(this.dataModels);
        buf.append(", declaredFacets: ");
        buf.append(this.declaredFacets);
        buf.append(", declaredSchemas: ");
        buf.append(this.declaredSchemas);
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Map<String, Serializable> getPrefetch() {
        return this.prefetch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Serializable> T getSystemProp(String systemProperty, Class<T> type) throws ClientException, DocumentException {
        CoreSession session = this.getCoreSession();
        if (session != null) {
            return session.getDocumentSystemProp(this.ref, systemProperty, type);
        }
        CoreSession tmpSession = this.getTempCoreSession();
        try {
            T t = tmpSession.getDocumentSystemProp(this.ref, systemProperty, type);
            return t;
        }
        finally {
            if (tmpSession != null) {
                CoreInstance.getInstance().close(tmpSession);
            }
        }
    }

    @Override
    public boolean isLifeCycleLoaded() {
        return this.currentLifeCycleState != null;
    }

    @Override
    public DocumentPart getPart(String schema) throws ClientException {
        DataModel dm = this.getDataModel(schema);
        if (dm != null) {
            return ((DataModelImpl)dm).getDocumentPart();
        }
        return null;
    }

    @Override
    public DocumentPart[] getParts() throws ClientException {
        DocumentType type;
        try {
            type = ((SchemaManager)Framework.getService(SchemaManager.class)).getDocumentType(this.getType());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Collection schemas = type.getSchemas();
        int size = schemas.size();
        DocumentPart[] parts = new DocumentPart[size];
        int i = 0;
        for (Schema schema : schemas) {
            DataModel dm = this.getDataModel(schema.getName());
            parts[i++] = ((DataModelImpl)dm).getDocumentPart();
        }
        return parts;
    }

    @Override
    public Property getProperty(String xpath) throws ClientException {
        DocumentPart part;
        Path path = new Path(xpath);
        if (path.segmentCount() == 0) {
            throw new PropertyNotFoundException(xpath, "Schema not specified");
        }
        String segment = path.segment(0);
        int p = segment.indexOf(58);
        if (p == -1) {
            DocumentPart[] parts;
            for (DocumentPart part2 : parts = this.getParts()) {
                if (!part2.getSchema().hasField(segment)) continue;
                return part2.resolvePath(path.toString());
            }
            throw new PropertyNotFoundException(xpath, "Schema not specified");
        }
        String prefix = segment.substring(0, p);
        SchemaManager mgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
        Schema schema = mgr.getSchemaFromPrefix(prefix);
        if (schema == null) {
            schema = mgr.getSchema(prefix);
            if (schema == null) {
                throw new PropertyNotFoundException(xpath, "Could not find registered schema with prefix: " + prefix);
            }
            String[] segments = path.segments();
            segments[0] = segments[0].substring(p + 1);
            path = Path.createFromSegments((String[])segments);
        }
        if ((part = this.getPart(schema.getName())) == null) {
            throw new PropertyNotFoundException(xpath, String.format("Document '%s' with title '%s' and type '%s' does not have any schema with prefix '%s'", this.getRef(), this.getTitle(), this.getType(), prefix));
        }
        return part.resolvePath(path.toString());
    }

    @Override
    public Serializable getPropertyValue(String path) throws PropertyException, ClientException {
        return this.getProperty(path).getValue();
    }

    @Override
    public void setPropertyValue(String path, Serializable value) throws PropertyException, ClientException {
        this.getProperty(path).setValue(value);
    }

    @Override
    public DocumentModel clone() throws CloneNotSupportedException {
        DocumentModelImpl dm = (DocumentModelImpl)super.clone();
        dm.declaredFacets = new HashSet<String>(this.declaredFacets);
        dm.contextData = new ScopedMap();
        dm.dataModels = new DataModelMapImpl();
        for (Map.Entry entry : this.dataModels.entrySet()) {
            DataModelImpl newData;
            String key = (String)entry.getKey();
            DataModel data = (DataModel)entry.getValue();
            try {
                newData = new DataModelImpl(key, data.getMap());
            }
            catch (PropertyException e) {
                throw new ClientRuntimeException(e);
            }
            dm.dataModels.put(key, newData);
        }
        return dm;
    }

    @Override
    public void reset() {
        if (this.dataModels != null) {
            this.dataModels.clear();
        }
        if (this.prefetch != null) {
            this.prefetch.clear();
        }
        this.isACPLoaded = false;
        this.acp = null;
        this.currentLifeCycleState = null;
        this.lifeCyclePolicy = null;
    }

    @Override
    public void refresh() throws ClientException {
        this.refresh(143, null);
    }

    @Override
    public void refresh(int refreshFlags, String[] schemas) throws ClientException {
        DocumentPart[] parts;
        if ((refreshFlags & 8) != 0 && this.isACPLoaded) {
            refreshFlags |= 0x20;
        }
        if ((refreshFlags & 0x40) != 0) {
            refreshFlags |= 0x100;
            Set keys = this.dataModels.keySet();
            schemas = keys.toArray(new String[keys.size()]);
        }
        Object[] result = this.getCoreSession().refreshDocument(this.ref, refreshFlags, schemas);
        if ((refreshFlags & 4) != 0) {
            this.prefetch = (HashMap)result[0];
        }
        if ((refreshFlags & 1) != 0) {
            this.lock = (String)result[1];
        }
        if ((refreshFlags & 2) != 0) {
            this.currentLifeCycleState = (String)result[2];
            this.lifeCyclePolicy = (String)result[3];
        }
        this.acp = null;
        this.isACPLoaded = false;
        if ((refreshFlags & 0x20) != 0) {
            this.acp = (ACP)result[4];
            this.isACPLoaded = true;
        }
        this.dataModels.clear();
        if ((refreshFlags & 0x100) != 0 && (parts = (DocumentPart[])result[5]) != null) {
            for (DocumentPart part : parts) {
                DataModelImpl dm = new DataModelImpl(part);
                this.dataModels.put(dm.getSchema(), dm);
            }
        }
    }
}

