/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultStreamBlob;

public class FileBlob
extends DefaultStreamBlob
implements Serializable {
    private static final long serialVersionUID = 373720300515677319L;
    protected transient File file;

    public FileBlob(File file) {
        this(file, null, null);
    }

    public FileBlob(File file, String ctype) {
        this(file, ctype, null);
    }

    public FileBlob(File file, String mimeType, String encoding) {
        this(file, mimeType, encoding, null, null);
    }

    public FileBlob(File file, String mimeType, String encoding, String filename, String digest) {
        this.file = file;
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.digest = digest;
        this.filename = filename;
    }

    public FileBlob(InputStream in) throws IOException {
        this(in, null, null);
    }

    public FileBlob(InputStream in, String ctype) throws IOException {
        this(in, ctype, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBlob(InputStream in, String mimeType, String encoding) throws IOException {
        this.mimeType = mimeType;
        this.encoding = encoding;
        OutputStream out = null;
        try {
            this.file = File.createTempFile("NXCore-FileBlob-", ".tmp");
            this.file.deleteOnExit();
            out = new FileOutputStream(this.file);
            FileBlob.copy(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
            if (out != null) {
                out.close();
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public long getLength() {
        return this.file == null ? 0L : this.file.length();
    }

    public InputStream getStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public Blob persist() {
        return this;
    }

    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.file = File.createTempFile("NXCore-FileBlob-", ".tmp");
        this.file.deleteOnExit();
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(this.file);
            byte[] buffer = new byte[65536];
            int bytes = in.readInt();
            while (bytes > -1 && (read = in.read(buffer, 0, bytes)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
                if ((bytes -= read) != 0) continue;
                bytes = in.readInt();
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        InputStream in = null;
        try {
            in = this.getStream();
            int read = 0;
            byte[] buf = new byte[65536];
            while ((read = in.read(buf)) != -1) {
                out.writeInt(read);
                out.write(buf, 0, read);
            }
            out.writeInt(-1);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    protected void finalize() throws Throwable {
        String name;
        if (this.file != null && (name = this.file.getName()).startsWith("NXCore-FileBlob-") && name.endsWith(".tmp")) {
            this.file.delete();
        }
        super.finalize();
    }
}

