/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.osm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAnnotationRegistry<T> {
    protected final Map<Class<?>, Annotation> registry = new HashMap();

    public synchronized T get(Class<?> type) {
        Annotation anno = this.lookup(type);
        return (T)anno.data;
    }

    public synchronized void put(Class<?> type, T data) {
        Annotation anno = this.registry.get(type);
        if (anno != null) {
            this.remove(type);
        }
        this.registry.put(type, new Annotation(type, null, data));
    }

    public synchronized void remove(Class<?> type) {
        Annotation anno = this.registry.remove(type);
        if (anno == null) {
            return;
        }
        Iterator<Annotation> it = this.registry.values().iterator();
        while (it.hasNext()) {
            if (it.next().provider != type) continue;
            it.remove();
        }
    }

    protected Annotation lookup(Class<?> type) {
        Annotation anno = this.registry.get(type);
        if (anno != null) {
            return anno;
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass == null) {
            for (Class<?> itf : type.getInterfaces()) {
                anno = this.lookup(itf);
                if (anno == null || anno.data == null) continue;
                this.registry.put(type, anno);
                return anno;
            }
        } else {
            LinkedList queue = new LinkedList();
            queue.add(type);
            anno = this.lookup(superClass, queue);
            if (anno != null && anno.data != null) {
                this.registry.put(type, new Annotation(type, anno.type, anno.data));
                return anno;
            }
            Class<?> t = queue.poll();
            while (t != null) {
                for (Class<?> itf : t.getInterfaces()) {
                    anno = this.lookup(itf);
                    if (anno == null || anno.data == null) continue;
                    this.registry.put(t, new Annotation(t, anno.type, anno.data));
                    return anno;
                }
                t = queue.poll();
            }
        }
        anno = new Annotation(type, null, null);
        this.registry.put(type, anno);
        return anno;
    }

    protected Annotation lookup(Class<?> type, Queue<Class<?>> queue) {
        Annotation anno = this.registry.get(type);
        if (anno != null) {
            return anno;
        }
        queue.add(type);
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            anno = this.lookup(superClass, queue);
        }
        if (anno == null) {
            anno = new Annotation(type, null, null);
        }
        this.registry.put(type, anno);
        return anno;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Annotation {
        final Class<?> type;
        final Class<?> provider;
        final Object data;

        public Annotation(Class<?> type, Class<?> provider, Object data) {
            this.type = type;
            this.provider = provider;
            this.data = data;
        }
    }
}

