/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.primitives;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolderAdapterService;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalBlobProperty
extends MapProperty {
    private static final long serialVersionUID = 1L;
    public static final String ENCODING = "encoding";
    public static final String MIME_TYPE = "mime-type";
    public static final String FILE_NAME = "name";
    public static final String DIGEST = "digest";
    public static final String LENGTH = "length";
    public static final String URI = "uri";

    public ExternalBlobProperty(Property parent, Field field, int flags) {
        super(parent, field, flags);
    }

    public ExternalBlobProperty(Property parent, Field field) {
        super(parent, field);
    }

    @Override
    public void init(Serializable value) throws PropertyException {
        Map<String, Serializable> map;
        if (value == null) {
            return;
        }
        if (value instanceof Map) {
            map = (Map<String, Serializable>)((Object)value);
        } else if (value instanceof Blob) {
            map = this.getMapFromBlobWithUri((Blob)((Object)value));
        } else {
            throw new PropertyException("Invalid value for external blob (map or blob needed): " + value);
        }
        for (Map.Entry entry : map.entrySet()) {
            Property property = this.get((String)entry.getKey());
            property.init((Serializable)entry.getValue());
        }
        this.removePhantomFlag();
    }

    @Override
    public Serializable internalGetValue() throws PropertyException {
        Serializable mapValue = super.internalGetValue();
        if (mapValue instanceof Map) {
            Blob blob = ExternalBlobProperty.getBlobFromMap((Map)((Object)mapValue));
            if (blob != null && !(blob instanceof Serializable)) {
                throw new PropertyException("Blob is not serializable: " + blob);
            }
            return (Serializable)((Object)blob);
        }
        if (mapValue != null) {
            throw new PropertyException("Invalid value for external blob (map needed): " + mapValue);
        }
        return null;
    }

    @Override
    public <T> T getValue(Class<T> type) throws PropertyException {
        Serializable value = super.internalGetValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            if (Map.class.isAssignableFrom(type)) {
                return (T)value;
            }
            if (Blob.class.isAssignableFrom(type)) {
                return (T)ExternalBlobProperty.getBlobFromMap((Map)((Object)value));
            }
        }
        throw new PropertyConversionException(value.getClass(), type);
    }

    @Override
    public Serializable getValueForWrite() throws PropertyException {
        return (Serializable)((Object)this.getValue(Map.class));
    }

    @Override
    public void setValue(Object value) throws PropertyException {
        if (!this.isContainer()) {
            super.setValue(value);
            return;
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyPropertyException(this.getPath());
        }
        if (value == null) {
            this.remove();
            return;
        }
        if (value instanceof Blob) {
            Property property = this.get(URI);
            Serializable uri = property.getValue();
            if (uri == null) {
                throw new PropertyException("Cannot set blob properties without an existing uri set");
            }
            Map<String, Serializable> map = ExternalBlobProperty.getMapFromBlob((Blob)value);
            for (Map.Entry<String, Serializable> entry : map.entrySet()) {
                String entryKey = entry.getKey();
                if (entryKey == URI) continue;
                property = this.get(entryKey);
                property.setValue(entry.getValue());
            }
            return;
        }
        if (!(value instanceof Map)) {
            throw new InvalidPropertyValueException(this.getPath());
        }
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            Property property = this.get((String)entry.getKey());
            property.setValue(entry.getValue());
        }
    }

    public static Blob getBlobFromMap(Map<String, Object> mapValue) {
        if (mapValue == null) {
            return null;
        }
        String uri = (String)mapValue.get(URI);
        if (uri == null || "".equals(uri)) {
            return null;
        }
        String filename = (String)mapValue.get(FILE_NAME);
        String mimeType = (String)mapValue.get(MIME_TYPE);
        String encoding = (String)mapValue.get(ENCODING);
        String digest = (String)mapValue.get(DIGEST);
        try {
            BlobHolderAdapterService service = (BlobHolderAdapterService)Framework.getService(BlobHolderAdapterService.class);
            if (service == null) {
                throw new DocumentException("BlobHolderAdapterService not found");
            }
            Blob blob = service.getExternalBlobForUri(uri);
            if (filename != null) {
                blob.setFilename(filename);
            }
            blob.setMimeType(mimeType);
            blob.setEncoding(encoding);
            blob.setDigest(digest);
            return blob;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Serializable> getMapFromBlobWithUri(Blob blob) throws PropertyException {
        Map<String, Serializable> map = ExternalBlobProperty.getMapFromBlob(blob);
        Property property = this.get(URI);
        Serializable uri = property.getValue();
        map.put(URI, uri);
        return map;
    }

    public static Map<String, Serializable> getMapFromBlob(Blob blob) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        if (blob == null) {
            map.put(FILE_NAME, null);
            map.put(MIME_TYPE, null);
            map.put(ENCODING, null);
            map.put(LENGTH, null);
            map.put(DIGEST, null);
        } else {
            map.put(FILE_NAME, (Serializable)((Object)blob.getFilename()));
            map.put(MIME_TYPE, (Serializable)((Object)blob.getMimeType()));
            map.put(ENCODING, (Serializable)((Object)blob.getEncoding()));
            map.put(LENGTH, Long.valueOf(blob.getLength()));
            map.put(DIGEST, (Serializable)((Object)blob.getDigest()));
        }
        return map;
    }
}

