/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.WrappedException;
import org.nuxeo.ecm.core.api.repository.MethodInvoker;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryConnection;
import org.nuxeo.ecm.core.api.repository.RepositoryExceptionHandler;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryInstanceHandler
implements InvocationHandler,
RepositoryConnection,
Serializable {
    public static final Object NULL = new Object();
    protected static final ConcurrentHashMap<Method, Method> methods = new ConcurrentHashMap();
    protected static ConcurrentHashMap<Method, MethodInvoker> invokers = new ConcurrentHashMap();
    protected final transient Repository repository;
    protected final transient RepositoryExceptionHandler exceptionHandler;
    protected transient CoreSession session;
    protected transient RepositoryInstance proxy;

    public RepositoryInstanceHandler(Repository repository, RepositoryExceptionHandler exceptionHandler) {
        this.repository = repository;
        this.exceptionHandler = exceptionHandler;
    }

    public RepositoryInstanceHandler(Repository repository) {
        this(repository, null);
    }

    public RepositoryExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public RepositoryInstance getProxy() {
        if (this.proxy == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = Repository.class.getClassLoader();
            }
            this.proxy = (RepositoryInstance)Proxy.newProxyInstance(cl, this.getProxyInterfaces(), (InvocationHandler)this);
        }
        return this.proxy;
    }

    public Class<?>[] getProxyInterfaces() {
        return new Class[]{RepositoryInstance.class};
    }

    protected static void rethrowException(Throwable t) throws Exception {
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw WrappedException.wrap(t);
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CoreSession getSession() throws Exception {
        if (this.session == null) {
            RepositoryInstanceHandler repositoryInstanceHandler = this;
            synchronized (repositoryInstanceHandler) {
                if (this.session == null) {
                    try {
                        this.open(this.repository);
                    }
                    catch (Throwable t) {
                        if (this.exceptionHandler != null) {
                            this.session = this.exceptionHandler.handleAuthenticationFailure(this.repository, t);
                        }
                        RepositoryInstanceHandler.rethrowException(t);
                    }
                }
            }
        }
        return this.session;
    }

    protected void open(Repository repository) throws Exception {
        this.session = (CoreSession)Framework.getService(CoreSession.class, (String)repository.getName());
        String repositoryUri = repository.getRepositoryUri();
        if (repositoryUri == null) {
            repositoryUri = repository.getName();
        }
        String sid = this.session.connect(repositoryUri, new HashMap<String, Serializable>());
        CoreInstance.getInstance().registerSession(sid, this.proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (this.session != null) {
            RepositoryInstanceHandler repositoryInstanceHandler = this;
            synchronized (repositoryInstanceHandler) {
                if (this.session != null) {
                    try {
                        CoreInstance.getInstance().close(this.session);
                    }
                    catch (Throwable t) {
                        if (this.exceptionHandler != null) {
                            this.exceptionHandler.handleException(t);
                        } else {
                            RepositoryInstanceHandler.rethrowException(t);
                        }
                    }
                    finally {
                        this.session = null;
                    }
                }
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getDeclaringClass() == CoreSession.class) {
                Method m = methods.get(method);
                if (m == null) {
                    try {
                        m = this.getClass().getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException e) {
                        m = method;
                    }
                    methods.put(method, m);
                }
                return m.invoke(m == method ? this.getSession() : this, args);
            }
            return method.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handleException(cause);
            }
            throw cause;
        }
        catch (Throwable t) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handleException(t);
            }
            throw t;
        }
    }

    protected Object getImpl() {
        return this;
    }

    public Object writeReplace() throws ObjectStreamException {
        return Proxy.getInvocationHandler(this.session);
    }
}

