/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManagerImpl
extends DefaultComponent
implements RepositoryManager {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.core.api.repository.RepositoryManager");
    private Map<String, Repository> repositories = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public void addRepository(Repository repository) {
        this.repositories.put(repository.getName(), repository);
    }

    @Override
    public Collection<Repository> getRepositories() {
        return new ArrayList<Repository>(this.repositories.values());
    }

    @Override
    public Repository getRepository(String name) {
        return this.repositories.get(name);
    }

    @Override
    public void removeRepository(String name) {
        this.repositories.remove(name);
    }

    @Override
    public void clear() {
        this.repositories.clear();
    }

    @Override
    public Repository getDefaultRepository() {
        Iterator<Repository> it = this.repositories.values().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public void activate(ComponentContext context) throws Exception {
        this.repositories = new Hashtable<String, Repository>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.repositories.clear();
        this.repositories = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("repositories".equals(extensionPoint)) {
            this.addRepository((Repository)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("repositories".equals(extensionPoint)) {
            this.removeRepository(((Repository)contribution).getName());
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (RepositoryManager.class.isAssignableFrom(adapter)) {
            return (T)this;
        }
        return null;
    }
}

