/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.repository.cache;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryExceptionHandler;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.api.repository.RepositoryInstanceHandler;
import org.nuxeo.ecm.core.api.repository.cache.CachingDocumentList;
import org.nuxeo.ecm.core.api.repository.cache.DocumentModelCache;
import org.nuxeo.ecm.core.api.repository.cache.SimpleDocumentModelIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingRepositoryInstanceHandler
extends RepositoryInstanceHandler
implements DocumentModelCache {
    protected Principal principal;
    protected String sessionId;
    protected final ConcurrentMap<String, DocumentModel> cache = new ConcurrentHashMap<String, DocumentModel>();
    protected final ConcurrentMap<String, String> path2Ids = new ConcurrentHashMap<String, String>();
    protected final Map<String, List<DocumentRef>> childrenCache = new HashMap<String, List<DocumentRef>>();

    public CachingRepositoryInstanceHandler(Repository repository) {
        super(repository);
    }

    public CachingRepositoryInstanceHandler(Repository repository, RepositoryExceptionHandler exceptionHandler) {
        super(repository, exceptionHandler);
    }

    @Override
    public Class<?>[] getProxyInterfaces() {
        return new Class[]{RepositoryInstance.class, DocumentModelCache.class};
    }

    public Principal getPrincipal() throws Exception {
        if (this.principal == null) {
            this.principal = this.getSession().getPrincipal();
        }
        return this.principal;
    }

    public String getSessionId() throws Exception {
        if (this.sessionId == null) {
            this.sessionId = this.getSession().getSessionId();
        }
        return this.sessionId;
    }

    public String getRepositoryName() {
        return this.repository.getName();
    }

    @Override
    public DocumentModel cacheDocument(DocumentModel doc) {
        String id = doc.getId();
        if (id != null) {
            DocumentModel cachedDoc = this.cache.putIfAbsent(id, doc);
            if (cachedDoc == null) {
                this.path2Ids.put(doc.getPathAsString(), id);
                return doc;
            }
            return cachedDoc;
        }
        return doc;
    }

    @Override
    public DocumentModel uncacheDocument(DocumentRef ref) {
        if (ref.type() == 1) {
            String id = ((IdRef)ref).value;
            DocumentModel doc = (DocumentModel)this.cache.remove(id);
            if (doc != null) {
                this.path2Ids.remove(doc.getPathAsString());
            }
            return doc;
        }
        String path = ((PathRef)ref).value;
        String id = (String)this.path2Ids.remove(path);
        if (id != null) {
            return (DocumentModel)this.cache.remove(id);
        }
        return null;
    }

    @Override
    public DocumentModel getCachedDocument(DocumentRef ref) {
        if (ref.type() == 1) {
            return (DocumentModel)this.cache.get(((IdRef)ref).value);
        }
        String id = (String)this.path2Ids.get(((PathRef)ref).value);
        if (id != null) {
            return (DocumentModel)this.cache.get(id);
        }
        return null;
    }

    @Override
    public void flushDocumentCache() {
        while (this.path2Ids.isEmpty() && this.cache.isEmpty()) {
            this.path2Ids.clear();
            this.cache.clear();
        }
    }

    @Override
    public DocumentModel fetchDocument(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.getCachedDocument(ref);
        if (doc != null) {
            doc.refresh(295, null);
            return doc;
        }
        return this.cacheDocument(this.session.getDocument(ref));
    }

    public DocumentModel getChild(DocumentRef parent, String name) throws ClientException {
        DocumentModel doc = this.getCachedDocument(parent);
        if (doc != null) {
            String path = doc.getPathAsString();
            String id = (String)this.path2Ids.get(path = new StringBuffer(path.length() + 256).append(path).append("/").append(name).toString());
            if (id != null && (doc = (DocumentModel)this.cache.get(id)) != null) {
                return doc;
            }
        }
        return this.cacheDocument(this.session.getChild(parent, name));
    }

    public DocumentModel getRootDocument() throws ClientException {
        DocumentModel doc;
        String id = (String)this.path2Ids.get("/");
        if (id != null && (doc = (DocumentModel)this.cache.get(id)) != null) {
            return doc;
        }
        return this.cacheDocument(this.session.getRootDocument());
    }

    public DocumentModel getDocument(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.getCachedDocument(ref);
        return doc != null ? doc : this.cacheDocument(this.session.getDocument(ref));
    }

    public DocumentModel getParentDocument(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.getCachedDocument(ref);
        if (doc != null) {
            return this.getDocument(doc.getParentRef());
        }
        return this.cacheDocument(this.session.getParentDocument(ref));
    }

    public DocumentModelList getChildren(DocumentRef parent) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            DocumentModelList result = this.getCachedChildren(parent);
            return result != null ? result : this.fetchAndCacheChildren(parent);
        }
        return new DocumentModelListImpl();
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent) throws ClientException {
        return new SimpleDocumentModelIterator(this.getChildren(parent));
    }

    public DocumentModelList query(String query) throws ClientException {
        return new CachingDocumentList(this, this.session.query(query));
    }

    public DocumentModelList getFiles(DocumentRef parent) throws ClientException {
        DocumentModelList docs = this.getCachedChildrenWithoutFacet(parent, "Folderish");
        if (docs == null) {
            docs = this.filterWithoutFacet(this.fetchAndCacheChildren(parent), "Folderish");
        }
        return docs;
    }

    public DocumentModelList getFolders(DocumentRef parent) throws ClientException {
        DocumentModelList docs = this.getCachedChildrenWithFacet(parent, "Folderish");
        if (docs == null) {
            docs = this.filterByFacet(this.fetchAndCacheChildren(parent), "Folderish");
        }
        return docs;
    }

    public DocumentModelList getChildren(DocumentRef parent, String type) throws ClientException {
        DocumentModelList docs = this.getCachedChildrenWithType(parent, type);
        if (docs == null) {
            docs = this.filterByType(this.fetchAndCacheChildren(parent), type);
        }
        return docs;
    }

    public DocumentModel createDocument(DocumentModel doc) throws ClientException {
        return this.cacheDocument(this.session.createDocument(doc));
    }

    public DocumentModel[] createDocument(DocumentModel[] docs) throws ClientException {
        docs = this.session.createDocument(docs);
        for (int i = docs.length - 1; i >= 0; --i) {
            docs[i] = this.cacheDocument(docs[i]);
        }
        return docs;
    }

    public DocumentModel createDocumentModel(String type) throws ClientException {
        return this.cacheDocument(this.session.createDocumentModel(type));
    }

    public DocumentModel createDocumentModel(String type, Map<String, Object> options) throws ClientException {
        return this.cacheDocument(this.session.createDocumentModel(type, options));
    }

    public DocumentModel createDocumentModel(String parentPath, String id, String type) throws ClientException {
        return this.cacheDocument(this.session.createDocumentModel(parentPath, id, type));
    }

    public DocumentModel createProxy(DocumentRef parentRef, DocumentRef docRef, VersionModel version, boolean overwriteExistingProxy) throws ClientException {
        return this.cacheDocument(this.session.createProxy(parentRef, docRef, version, overwriteExistingProxy));
    }

    public String getDocumentId(DocumentRef docRef) {
        switch (docRef.type()) {
            case 1: {
                return (String)docRef.reference();
            }
            case 2: {
                String path = (String)docRef.reference();
                return (String)this.path2Ids.get(path);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheChildren(DocumentRef parent, DocumentModelList children) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            ArrayList<DocumentRef> cache = new ArrayList<DocumentRef>();
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                DocumentModel child = (DocumentModel)children.get(i);
                child = this.cacheDocument(child);
                children.set(i, child);
                cache.add(child.getRef());
            }
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                this.childrenCache.put(id, cache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncacheChildren(DocumentRef parent) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                this.childrenCache.remove(id);
            }
        }
    }

    @Override
    public DocumentModelList fetchChildren(DocumentRef parent) throws Exception {
        return this.getSession().getChildren(parent);
    }

    public DocumentModelList filterByFacet(DocumentModelList docs, String facet) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (!doc.hasFacet(facet)) continue;
            result.add(doc);
        }
        return result;
    }

    public DocumentModelList filterWithoutFacet(DocumentModelList docs, String facet) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (doc.hasFacet(facet)) continue;
            result.add(doc);
        }
        return result;
    }

    public DocumentModelList filterByType(DocumentModelList docs, String type) {
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (!type.equals(doc.getType())) continue;
            result.add(doc);
        }
        return result;
    }

    @Override
    public DocumentModelList fetchAndCacheChildren(DocumentRef parent) throws ClientException {
        try {
            DocumentModelList children = this.getSession().getChildren(parent);
            this.cacheChildren(parent, children);
            return children;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to get proxy session", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentModelList getCachedChildren(DocumentRef parent) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    result.add(this.getDocument(ref));
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList getCachedChildrenWithType(DocumentRef parent, String type) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    DocumentModel doc = this.getDocument(ref);
                    if (!type.equals(doc.getType())) continue;
                    result.add(doc);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList getCachedChildrenWithFacet(DocumentRef parent, String facet) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    DocumentModel doc = this.getDocument(ref);
                    if (!doc.hasFacet(facet)) continue;
                    result.add(doc);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList getCachedChildrenWithoutFacet(DocumentRef parent, String facet) throws ClientException {
        String id = this.getDocumentId(parent);
        if (id != null) {
            List<DocumentRef> children = null;
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                children = this.childrenCache.get(id);
            }
            if (children != null) {
                DocumentRef[] refs = children.toArray(new DocumentRef[children.size()]);
                DocumentModelListImpl result = new DocumentModelListImpl();
                for (DocumentRef ref : refs) {
                    DocumentModel doc = this.getDocument(ref);
                    if (doc.hasFacet(facet)) continue;
                    result.add(doc);
                }
                return result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheChild(DocumentRef parent, DocumentRef child) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                List<DocumentRef> list = this.childrenCache.get(id);
                if (list == null) {
                    list = new ArrayList<DocumentRef>();
                    this.childrenCache.put(id, list);
                }
                list.add(child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncacheChild(DocumentRef parent, DocumentRef child) {
        String id = this.getDocumentId(parent);
        if (id != null) {
            Map<String, List<DocumentRef>> map = this.childrenCache;
            synchronized (map) {
                List<DocumentRef> list = this.childrenCache.get(id);
                if (list != null) {
                    list.remove(child);
                }
            }
        }
    }
}

