/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.url.nxdoc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.url.nxobj.ObjectURLConnection;

public class LocalPropertyURLConnection
extends ObjectURLConnection {
    protected Property property;

    LocalPropertyURLConnection(URL url) {
        super(url);
    }

    public Property getProperty() throws IOException {
        try {
            if (this.property == null) {
                String xpath = this.url.getPath();
                this.property = ((DocumentModel)this.obj).getProperty(xpath);
            }
            return this.property;
        }
        catch (ClientException e) {
            IOException ee = new IOException("Failed to get property: " + this.url.getPath());
            ee.initCause(e);
            throw ee;
        }
    }

    protected long lastModified() throws IOException {
        try {
            Calendar cal;
            DocumentPart part = ((DocumentModel)this.obj).getPart("dublincore");
            if (part != null && (cal = (Calendar)((Object)part.get("modified"))) != null) {
                return cal.getTimeInMillis();
            }
        }
        catch (ClientException e) {
            IOException ee = new IOException("Failed to get last modified property");
            ee.initCause(e);
            throw ee;
        }
        return this.getProperty().isDirty() ? -1L : 0L;
    }

    protected InputStream openStream() throws IOException {
        Property p = this.getProperty();
        try {
            Serializable value = p.getValue();
            if (value == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (value instanceof Blob) {
                return ((Blob)((Object)value)).getStream();
            }
            if (value instanceof InputStream) {
                return (InputStream)((Object)value);
            }
            return new ByteArrayInputStream(value.toString().getBytes());
        }
        catch (PropertyException e) {
            throw new IOException("Failed to get property value: " + p.getName());
        }
    }
}

