/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.directory.sql.repository.Column;
import org.nuxeo.ecm.directory.sql.repository.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Insert
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Dialect dialect;
    private Table table;
    private final List<Column> columns;

    public Insert(Dialect dialect) {
        this.dialect = dialect;
        this.columns = new ArrayList<Column>();
    }

    public Insert(Dialect dialect, Table table, List<Column> columns) {
        this.dialect = dialect;
        this.table = table;
        this.columns = new ArrayList<Column>(columns);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public String getStatement() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("insert into ");
        buf.append(this.table.getQuotedName(this.dialect));
        buf.append(' ');
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<String> values = new LinkedList<String>();
        for (Column column : this.columns) {
            if (column.isIdentity()) continue;
            columnNames.add(column.getQuotedName(this.dialect));
            values.add("?");
        }
        if (columnNames.isEmpty()) {
            buf.append(this.dialect.getNoColumnsInsertString());
        } else {
            buf.append('(');
            buf.append(StringUtils.join(columnNames, (String)", "));
            buf.append(") values (");
            buf.append(StringUtils.join(values, (String)", "));
            buf.append(')');
        }
        return buf.toString();
    }
}

