/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql.repository;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.nuxeo.ecm.directory.sql.repository.Column;
import org.nuxeo.ecm.directory.sql.repository.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, Column> columnMap = new HashMap<String, Column>();
    private final List<Column> columns = new ArrayList<Column>();
    private Column primaryColumn;

    public Table(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return dialect.openQuote() + this.name + dialect.closeQuote();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void addColumn(Column column) throws ConfigurationException {
        if (column == null) {
            throw new IllegalArgumentException("addColumn: column cannot be null");
        }
        String name = column.getName();
        if (this.columnMap.keySet().contains(name)) {
            throw new ConfigurationException("duplicate column " + column);
        }
        if (column.isPrimary()) {
            if (this.primaryColumn != null) {
                throw new ConfigurationException("Identity column " + this.primaryColumn + " redefined as " + column);
            }
            this.primaryColumn = column;
            this.columns.add(0, column);
            this.columnMap.put(name, column);
        } else {
            this.columnMap.put(name, column);
            this.columns.add(column);
        }
    }

    public String getCreateSql(Dialect dialect) {
        StringBuilder buf = new StringBuilder();
        char openQuote = dialect.openQuote();
        char closeQuote = dialect.closeQuote();
        buf.append("create table");
        buf.append(' ');
        buf.append(openQuote);
        buf.append(this.name);
        buf.append(closeQuote);
        buf.append(" (");
        boolean first = true;
        for (Column column : this.columns) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(openQuote);
            buf.append(column.getName());
            buf.append(closeQuote);
            buf.append(' ');
            if (column.isIdentity()) {
                if (dialect.hasDataTypeInIdentityColumn()) {
                    buf.append(column.getSqlTypeString(dialect));
                    buf.append(' ');
                }
                buf.append(dialect.getIdentityColumnString(column.getSqlType()));
                continue;
            }
            buf.append(column.getSqlTypeString(dialect));
            String defaultValue = column.getDefaultValue();
            if (defaultValue != null) {
                buf.append(" default ");
                buf.append(defaultValue);
            }
            if (column.isNullable()) {
                buf.append(dialect.getNullColumnString());
                continue;
            }
            buf.append(" not null");
        }
        buf.append(')');
        buf.append(dialect.getTableTypeString());
        return buf.toString();
    }

    public String getDropSql(Dialect dialect) {
        StringBuilder buf = new StringBuilder();
        buf.append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        buf.append(dialect.openQuote());
        buf.append(this.name);
        buf.append(dialect.closeQuote());
        buf.append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public Column getColumn(String name) {
        if (name == null) {
            throw new IllegalArgumentException("getColumn: name cannot be null");
        }
        return this.columnMap.get(name);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.name + ')';
    }

    public Column getPrimaryColumn() {
        return this.primaryColumn;
    }
}

