/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.convert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CropPictureConverter
implements Converter {
    private static final Log log = LogFactory.getLog(CropPictureConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            ImagingService service = (ImagingService)Framework.getService(ImagingService.class);
            ArrayList<Blob> results = new ArrayList<Blob>();
            List sources = blobHolder.getBlobs();
            int height = (Integer)parameters.get("height");
            int width = (Integer)parameters.get("width");
            int x = (Integer)parameters.get("x");
            int y = (Integer)parameters.get("y");
            for (Blob source : sources) {
                Blob result;
                if (source == null || (result = service.crop(source, x, y, width, height)) == null) continue;
                results.add(result);
            }
            return new SimpleCachableBlobHolder(results);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new ConversionException("Crop conversion has failed", e);
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

