/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.PictureViewImpl;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiviewPictureAdapter
implements MultiviewPicture {
    public static final String FIELD_HEADLINE = "headline";
    public static final String FIELD_SUBHEADLINE = "subheadline";
    public static final String FIELD_BYLINE = "byline";
    public static final String FIELD_DATELINE = "dateline";
    public static final String FIELD_SLUGLINE = "slugline";
    public static final String FIELD_CREDIT = "credit";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_ORIGIN = "origin";
    public static final String FIELD_GENRE = "genre";
    public static final String FIELD_CAPTION = "caption";
    public static final String FIELD_TYPAGE = "typage";
    public static final String SCHEMA_NAME = "picture";
    final DocumentModel docModel;
    final Map<String, PictureView> views = new HashMap<String, PictureView>();

    public static Map<String, Object> viewToMap(PictureView view) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", view.getTitle());
        map.put("description", view.getDescription());
        map.put("tag", view.getTag());
        map.put("height", view.getHeight());
        map.put("width", view.getWidth());
        map.put("filename", view.getFilename());
        Object o = view.getContent();
        FileBlob blob = null;
        if (o instanceof File) {
            blob = new FileBlob((File)o, "application/octet-stream");
        } else if (o instanceof InputStream) {
            blob = new InputStreamBlob((InputStream)o, "application/octet-stream");
        } else if (o instanceof Blob) {
            blob = (Blob)o;
        }
        if (blob != null) {
            map.put("content", blob);
        }
        return map;
    }

    public static PictureView mapToView(Map<String, Object> map) {
        PictureViewImpl view = new PictureViewImpl();
        view.setTitle((String)map.get("title"));
        view.setDescription((String)map.get("description"));
        view.setTag((String)map.get("tag"));
        Object o = map.get("width");
        if (o != null) {
            view.setWidth(((Number)o).intValue());
        }
        if ((o = map.get("height")) != null) {
            view.setHeight(((Number)o).intValue());
        }
        view.setFilename((String)map.get("filename"));
        view.setContent(map.get("content"));
        return view;
    }

    public MultiviewPictureAdapter(DocumentModel docModel) throws ClientException {
        this.docModel = docModel;
        Object o = docModel.getProperty(SCHEMA_NAME, "views");
        List list = (List)docModel.getProperty(SCHEMA_NAME, "views");
        if (list != null) {
            for (Map map : list) {
                PictureView view = MultiviewPictureAdapter.mapToView(map);
                this.views.put(view.getTitle(), view);
            }
        }
    }

    @Override
    public PictureView[] getViews() {
        Collection<PictureView> collection = this.views.values();
        return collection.toArray(new PictureView[collection.size()]);
    }

    @Override
    public PictureView getView(String title) {
        return this.views.get(title);
    }

    @Override
    public void removeView(String name) throws ClientException {
        this.views.remove(name);
        ArrayList<Map<String, Object>> v = new ArrayList<Map<String, Object>>();
        for (PictureView view : this.views.values()) {
            v.add(MultiviewPictureAdapter.viewToMap(view));
        }
        this.docModel.setProperty(SCHEMA_NAME, "views", (Object)v.toArray());
    }

    @Override
    public void addView(PictureView view) throws ClientException {
        this.views.put(view.getTitle(), view);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (PictureView pv : this.views.values()) {
            list.add(MultiviewPictureAdapter.viewToMap(pv));
        }
        this.docModel.setProperty(SCHEMA_NAME, "views", list);
    }

    @Override
    public void removeAllView() throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, "views", null);
        this.views.clear();
    }

    @Override
    public String getHeadline() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_HEADLINE);
    }

    @Override
    public void setHeadline(String headline) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_HEADLINE, (Object)headline);
    }

    @Override
    public String getSubheadline() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_SUBHEADLINE);
    }

    @Override
    public void setSubheadline(String subheadline) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_SUBHEADLINE, (Object)subheadline);
    }

    @Override
    public String getByline() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_BYLINE);
    }

    @Override
    public void setByline(String byline) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_BYLINE, (Object)byline);
    }

    @Override
    public String getDateline() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_DATELINE);
    }

    @Override
    public void setDateline(String dateline) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_DATELINE, (Object)dateline);
    }

    @Override
    public String getSlugline() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_SLUGLINE);
    }

    @Override
    public void setSlugline(String slugline) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_SLUGLINE, (Object)slugline);
    }

    @Override
    public String getCredit() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_CREDIT);
    }

    @Override
    public void setCredit(String credit) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_CREDIT, (Object)credit);
    }

    @Override
    public String getLanguage() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_LANGUAGE);
    }

    @Override
    public void setLanguage(String language) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_LANGUAGE, (Object)language);
    }

    @Override
    public String getSource() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_SOURCE);
    }

    @Override
    public void setSource(String source) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_SOURCE, (Object)source);
    }

    @Override
    public String getOrigin() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_ORIGIN);
    }

    @Override
    public void setOrigin(String origin) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_ORIGIN, (Object)origin);
    }

    @Override
    public String getGenre() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_GENRE);
    }

    @Override
    public void setGenre(String genre) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_GENRE, (Object)genre);
    }

    @Override
    public String getCaption() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_CAPTION);
    }

    @Override
    public void setCaption(String caption) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_CAPTION, (Object)caption);
    }

    @Override
    public String getTypage() throws ClientException {
        return (String)this.docModel.getProperty(SCHEMA_NAME, FIELD_TYPAGE);
    }

    @Override
    public void setTypage(String typage) throws ClientException {
        this.docModel.setProperty(SCHEMA_NAME, FIELD_TYPAGE, (Object)typage);
    }
}

