/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.DocumentBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PictureBlobHolder
extends DocumentBlobHolder {
    public PictureBlobHolder(DocumentModel doc, String path) {
        super(doc, path);
    }

    public Blob getBlob() throws ClientException {
        return this.getBlob("Original");
    }

    public void setBlob(Blob blob) throws ClientException {
        this.xPathFilename = null;
        ArrayList pictureTemplates = null;
        DocumentModel parent = this.doc.getCoreSession().getParentDocument(this.doc.getRef());
        if (parent.getType().equals("PictureBook") && (pictureTemplates = (ArrayList)parent.getProperty("picturebook", "picturetemplates")).size() == 0) {
            pictureTemplates = null;
        }
        PictureResourceAdapter picture = (PictureResourceAdapter)this.doc.getAdapter(PictureResourceAdapter.class);
        String filename = blob == null ? null : blob.getFilename();
        String title = (String)this.doc.getProperty("dublincore", "title");
        try {
            picture.createPicture(blob, filename, title, pictureTemplates);
        }
        catch (IOException e) {
            throw new ClientException(e.toString(), (Throwable)e);
        }
    }

    public List<Blob> getBlobs() throws ClientException {
        ArrayList<Blob> blobList = new ArrayList<Blob>();
        Collection views = this.doc.getProperty("picture:views").getChildren();
        for (Property property : views) {
            blobList.add((Blob)property.getValue("content"));
        }
        return blobList;
    }

    public List<Blob> getBlobs(String ... viewNames) throws ClientException {
        ArrayList<Blob> blobList = new ArrayList<Blob>();
        for (int i = 0; i < viewNames.length; ++i) {
            blobList.add(this.getBlob(viewNames[i]));
        }
        return blobList;
    }

    public Blob getBlob(String title) throws ClientException {
        PictureResourceAdapter picture = (PictureResourceAdapter)this.doc.getAdapter(PictureResourceAdapter.class);
        return picture.getPictureFromTitle(title);
    }

    public String getHash() throws ClientException {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + this.getModificationDate().toString();
    }
}

