/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.picture.config.PictureAdapterDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PictureConfigurationService
extends DefaultComponent {
    public static final String NAME = "org.nuxeo.ecm.platform.picture.config.PictureConfigurationService";
    public static final String PICTURE_ADAPTER_EP = "PictureAdapter";
    public static final String DEFAULT_CONFIGURATION = "default";
    private static final Log log = LogFactory.getLog(PictureConfigurationService.class);
    private static Map<String, PictureAdapterDescriptor> pictureAdapterDescriptors;

    public void activate(ComponentContext context) {
        pictureAdapterDescriptors = new HashMap<String, PictureAdapterDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        pictureAdapterDescriptors = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(PICTURE_ADAPTER_EP)) {
            PictureAdapterDescriptor pictureAdapter = (PictureAdapterDescriptor)contribution;
            PictureConfigurationService.registerPictureAdapter(pictureAdapter, contributor);
        } else {
            log.error((Object)("Extension point " + extensionPoint + "is unknown"));
        }
    }

    public static void registerPictureAdapter(PictureAdapterDescriptor pictureAdapter, ComponentInstance contributor) {
        pictureAdapterDescriptors.put(pictureAdapter.getTypeName(), pictureAdapter);
        log.debug((Object)("registered Picture Adapterdescriptor: " + pictureAdapter.getName()));
    }

    public static PictureResourceAdapter getAdapterForType(String docType) throws InstantiationException, IllegalAccessException {
        PictureAdapterDescriptor dad = pictureAdapterDescriptors.get(docType);
        if (dad != null) {
            return dad.getNewInstance();
        }
        return null;
    }
}

