/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.io.api.util;

import java.io.IOException;
import java.util.Collection;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.io.api.util.IOConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOHelper {
    private IOHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(IOConfiguration src, IOConfiguration dest, Collection<String> ioAdapters) throws IOException, ClientException {
        String uri = IOHelper.exportAsStream(src, ioAdapters);
        try {
            IOHelper.importFromStream(dest, uri);
        }
        finally {
            if (uri != null) {
                // empty if block
            }
        }
    }

    public static String exportAsStream(IOConfiguration location, Collection<String> ioAdapters) throws ClientException {
        return location.getManager().externalizeExport(location.getRepositoryName(), location.getDocuments(), (String)location.getProperty("org.nuxeo.ecm.core.io.doc_reader_factory"), location.getProperties(), ioAdapters);
    }

    public static void importFromStream(IOConfiguration location, String streamUri) throws ClientException {
        String docWriterFactoryName = (String)location.getProperty("org.nuxeo.ecm.core.io.doc_writer_factory");
        DocumentLocationImpl targetLocation = new DocumentLocationImpl(location.getRepositoryName(), location.getFirstDocument());
        if (docWriterFactoryName == null) {
            location.getManager().importExportedFile(streamUri, (DocumentLocation)targetLocation);
        } else {
            location.getManager().importExportedFile(streamUri, (DocumentLocation)targetLocation, docWriterFactoryName, location.getProperties());
        }
    }
}

