/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.listeners;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.platform.versioning.BasicVersionChangeRequest;
import org.nuxeo.ecm.platform.versioning.VersionChangeRequest;
import org.nuxeo.ecm.platform.versioning.api.VersionIncEditOptions;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.platform.versioning.service.ServiceHelper;
import org.nuxeo.ecm.platform.versioning.service.VersioningService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocVersioningEventListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DocVersioningEventListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            this.doProcess(event.getName(), (DocumentEventContext)ctx);
        }
    }

    protected void doProcess(String eventId, DocumentEventContext ctx) throws ClientException {
        VersionChangeRequest req;
        DocumentModel doc = ctx.getSourceDocument();
        if (doc.getContextData(ScopeType.REQUEST, "SKIP_VERSIONING") == Boolean.TRUE) {
            return;
        }
        VersioningService versioningService = ServiceHelper.getVersioningService();
        if (versioningService == null) {
            log.debug((Object)"No versioning service");
            return;
        }
        String docType = doc.getType();
        String majorPropName = versioningService.getMajorVersionPropertyName(docType);
        String minorPropName = versioningService.getMinorVersionPropertyName(docType);
        Map options = ctx.getProperties();
        if (eventId.equals("documentCreated") && !doc.isVersion() && !doc.isProxy()) {
            try {
                doc.setProperty(DocumentModelUtils.getSchemaName((String)majorPropName), DocumentModelUtils.getFieldName((String)majorPropName), (Object)1L);
                doc.setProperty(DocumentModelUtils.getSchemaName((String)minorPropName), DocumentModelUtils.getFieldName((String)minorPropName), (Object)0L);
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            return;
        }
        if (eventId.equals("documentCheckedOut")) {
            req = DocVersioningEventListener.getVersionChangeRequest(doc, options);
            if (req == null) {
                req = DocVersioningEventListener.createAutoChangeRequest(doc);
            }
        } else if (eventId.equals("incrementBeforeUpdate")) {
            if (options.get("DOCUMENT_WAS_SNAPSHOTTED") == Boolean.TRUE) {
                return;
            }
            req = DocVersioningEventListener.getVersionChangeRequest(doc, options);
        } else {
            if (eventId.equals("documentRestored")) {
                if (options == null) {
                    log.warn((Object)"options is null. versions not available");
                    return;
                }
                try {
                    doc.setProperty(DocumentModelUtils.getSchemaName((String)majorPropName), DocumentModelUtils.getFieldName((String)majorPropName), options.get("CURRENT_DOCUMENT_MAJOR_VERSION"));
                    doc.setProperty(DocumentModelUtils.getSchemaName((String)minorPropName), DocumentModelUtils.getFieldName((String)minorPropName), options.get("CURRENT_DOCUMENT_MINOR_VERSION"));
                }
                catch (ClientException e) {
                    throw new ClientRuntimeException((Throwable)e);
                }
                return;
            }
            return;
        }
        log.debug((Object)("req: " + req));
        if (req == null) {
            return;
        }
        try {
            versioningService.incrementVersions(req);
        }
        catch (ClientException e) {
            log.error((Object)("Error incrementing versions for: " + doc), (Throwable)e);
        }
    }

    protected static VersionChangeRequest getVersionChangeRequest(DocumentModel doc, Map<String, Serializable> options) throws ClientException {
        if (DocVersioningEventListener.isIncOptionUserSelected(doc)) {
            if (options == null) {
                return null;
            }
            VersioningActions incOption = (VersioningActions)options.get("VersioningOption");
            if (incOption == null) {
                return null;
            }
            return DocVersioningEventListener.createEditChangeRequest(doc, incOption);
        }
        return DocVersioningEventListener.createAutoChangeRequest(doc);
    }

    protected static VersionChangeRequest createAutoChangeRequest(DocumentModel doc) {
        return new BasicVersionChangeRequest(VersionChangeRequest.RequestSource.AUTO, doc){

            public VersioningActions getVersioningAction() {
                log.warn((Object)"Rule for AUTO not correctly defined");
                return null;
            }
        };
    }

    protected static VersionChangeRequest createEditChangeRequest(DocumentModel doc, final VersioningActions incOption) {
        return new BasicVersionChangeRequest(VersionChangeRequest.RequestSource.EDIT, doc){

            public VersioningActions getVersioningAction() {
                return incOption;
            }
        };
    }

    protected static boolean isIncOptionUserSelected(DocumentModel doc) throws ClientException {
        VersioningService versioningService = ServiceHelper.getVersioningService();
        VersionIncEditOptions options = versioningService.getVersionIncEditOptions(doc);
        if (options.getVersioningAction() == VersioningActions.ACTION_CASE_DEPENDENT) {
            log.debug((Object)("available options: " + options));
            return true;
        }
        return false;
    }
}

