/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.versioning.service.VersioningModifierDescriptor;
import org.nuxeo.ecm.platform.versioning.service.VersioningModifierPropertyDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersioningModifierService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.versioning.service.VersioningModifierService");
    private static final Log log = LogFactory.getLog(VersioningModifierService.class);
    private Map<String, List<VersioningModifierPropertyDescriptor>> modifications;

    public void activate(ComponentContext context) {
        log.info((Object)"Activate versioningModifer extension");
        this.modifications = new HashMap<String, List<VersioningModifierPropertyDescriptor>>();
    }

    public void deactivate(ComponentContext context) {
        this.modifications = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("versioningModifier")) {
            log.info((Object)"Registering versioningModifer contribution");
            try {
                VersioningModifierDescriptor versionModifierDesc = (VersioningModifierDescriptor)contribution;
                List<VersioningModifierPropertyDescriptor> properties = VersioningModifierService.registerProperties(versionModifierDesc);
                this.modifications.put(versionModifierDesc.getDocumentType(), properties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("versioningModifier")) {
            log.info((Object)"Unregistering versioningModifer contribution");
            try {
                VersioningModifierDescriptor versionModifierDesc = (VersioningModifierDescriptor)contribution;
                this.modifications.remove(versionModifierDesc.getDocumentType());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static List<VersioningModifierPropertyDescriptor> registerProperties(VersioningModifierDescriptor versionModiferDesc) {
        ArrayList<VersioningModifierPropertyDescriptor> properties = new ArrayList<VersioningModifierPropertyDescriptor>();
        for (VersioningModifierPropertyDescriptor property : versionModiferDesc.getProperties()) {
            properties.add(property);
        }
        return properties;
    }

    public void doModifications(DocumentModel document) {
        if (document != null && this.modifications != null && !this.modifications.isEmpty()) {
            List<VersioningModifierPropertyDescriptor> properties = this.modifications.get(document.getType());
            if (properties == null || properties.isEmpty()) {
                log.debug((Object)("No properties modifications for document type " + document.getType()));
            } else {
                for (VersioningModifierPropertyDescriptor property : properties) {
                    VersioningModifierService.performModifications(document, property.getSchema(), property.getFieldname(), property.getAction());
                }
            }
        }
    }

    private static void performModifications(DocumentModel document, String schema, String fieldname, String action) {
        log.debug((Object)("performing  " + action + " on " + document.getId()));
        if ("reset".equals(action)) {
            VersioningModifierService.performReset(document, schema, fieldname);
        }
    }

    private static void performReset(DocumentModel document, String schema, String fieldname) {
        if (document != null && !"".equals(schema) && !"".equals(fieldname)) {
            try {
                document.setProperty(schema, fieldname, null);
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            log.debug((Object)(schema + ':' + fieldname + " resetted"));
        }
    }
}

