/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.versioning.service;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.utils.DocumentModelUtils;
import org.nuxeo.ecm.platform.versioning.VersionChangeRequest;
import org.nuxeo.ecm.platform.versioning.api.SnapshotOptions;
import org.nuxeo.ecm.platform.versioning.api.VersionIncEditOptions;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.platform.versioning.api.VersioningManager;
import org.nuxeo.ecm.platform.versioning.service.AutoBasedRuleDescriptor;
import org.nuxeo.ecm.platform.versioning.service.CreateSnapshotDescriptor;
import org.nuxeo.ecm.platform.versioning.service.EditBasedRuleDescriptor;
import org.nuxeo.ecm.platform.versioning.service.RuleDescriptor;
import org.nuxeo.ecm.platform.versioning.service.RuleOptionDescriptor;
import org.nuxeo.ecm.platform.versioning.service.VersioningPropertiesDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Property;

public class VersioningService
extends DefaultComponent
implements VersioningManager {
    public static final String COMPONENT_ID = "org.nuxeo.ecm.platform.versioning.service.VersioningService";
    public static final String VERSIONING_EXTENSION_POINT_RULES = "rules";
    public static final String VERSIONING_EXTENSION_POINT_PROPERTIES = "properties";
    private static final Log log = LogFactory.getLog(VersioningService.class);
    private final Map<String, EditBasedRuleDescriptor> editRuleDescriptors = new LinkedHashMap<String, EditBasedRuleDescriptor>();
    private final Map<String, AutoBasedRuleDescriptor> autoRuleDescriptors = new LinkedHashMap<String, AutoBasedRuleDescriptor>();
    private final Map<String, VersioningPropertiesDescriptor> propertiesDescriptors = new HashMap<String, VersioningPropertiesDescriptor>();
    private final Map<String, CreateSnapshotDescriptor> snapshotDescriptors = new HashMap<String, CreateSnapshotDescriptor>();
    private String minorVersionProperty;
    private String majorVersionProperty;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.minorVersionProperty = VersioningService.getPropertyFallback(context, "defaultMinorVersion", "uid:minor_version");
        this.majorVersionProperty = VersioningService.getPropertyFallback(context, "defaultMajorVersion", "uid:major_version");
    }

    private static String getPropertyFallback(ComponentContext context, String propName, String defaultValue) {
        Property p = context.getProperty(propName);
        if (p != null) {
            try {
                return (String)p.getValue();
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        this.editRuleDescriptors.clear();
        this.autoRuleDescriptors.clear();
        this.propertiesDescriptors.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        VersioningPropertiesDescriptor descriptor;
        List<String> docTypes;
        if (VERSIONING_EXTENSION_POINT_RULES.equals(extensionPoint)) {
            if (contribution instanceof EditBasedRuleDescriptor) {
                EditBasedRuleDescriptor descriptor2 = (EditBasedRuleDescriptor)contribution;
                String name = descriptor2.getName();
                if (this.editRuleDescriptors.containsKey(name)) {
                    log.debug((Object)("deleting contribution " + name));
                    this.editRuleDescriptors.remove(name);
                }
                this.editRuleDescriptors.put(name, descriptor2);
                log.debug((Object)("added a " + EditBasedRuleDescriptor.class.getSimpleName()));
            } else if (contribution instanceof AutoBasedRuleDescriptor) {
                AutoBasedRuleDescriptor descriptor3 = (AutoBasedRuleDescriptor)contribution;
                String name = descriptor3.getName();
                if (this.autoRuleDescriptors.containsKey(name)) {
                    log.debug((Object)("deleting contribution " + name));
                    this.autoRuleDescriptors.remove(name);
                }
                this.autoRuleDescriptors.put(name, descriptor3);
                log.debug((Object)("added a " + AutoBasedRuleDescriptor.class.getSimpleName()));
            } else if (contribution instanceof CreateSnapshotDescriptor) {
                CreateSnapshotDescriptor descriptor4 = (CreateSnapshotDescriptor)contribution;
                String name = descriptor4.getName();
                if (this.snapshotDescriptors.containsKey(name)) {
                    log.debug((Object)("override snapshot descriptor: " + name));
                    this.snapshotDescriptors.remove(name);
                }
                this.snapshotDescriptors.put(name, descriptor4);
                log.debug((Object)("added " + descriptor4));
            } else {
                log.warn((Object)("Descriptor not handled: " + contribution));
            }
        } else if (VERSIONING_EXTENSION_POINT_PROPERTIES.equals(extensionPoint) && (docTypes = (descriptor = (VersioningPropertiesDescriptor)contribution).getDocumentTypes()) != null) {
            for (String docType : docTypes) {
                if (this.propertiesDescriptors.containsKey(docType)) {
                    log.debug((Object)("Override versioning properties for document type " + docType));
                    this.propertiesDescriptors.remove(docType);
                }
                this.propertiesDescriptors.put(docType, descriptor);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public VersionIncEditOptions getVersionIncEditOptions(DocumentModel document) throws ClientException {
        DocumentType type = document.getDocumentType();
        if (!type.getFacets().contains("Versionable")) {
            VersionIncEditOptions vincOpt = new VersionIncEditOptions();
            vincOpt.setVersioningAction(VersioningActions.NO_VERSIONING);
            vincOpt.addInfo("Type doesn't have the Versionable facet: " + type.getName());
            return vincOpt;
        }
        if (null == document.getSessionId()) {
            throw new IllegalArgumentException("document model is not bound to a core session (null sessionId)");
        }
        CoreSession coreSession = CoreInstance.getInstance().getSession(document.getSessionId());
        if (coreSession == null) {
            throw new ClientException("cannot get core session for doc: " + document);
        }
        String lifecycleState = coreSession.getCurrentLifeCycleState(document.getRef());
        if (lifecycleState == null) {
            VersionIncEditOptions vincOpt = new VersionIncEditOptions();
            vincOpt.addInfo("Document doesn't have a lifecycle state");
            return vincOpt;
        }
        return this.getVersionIncOptions(lifecycleState, document);
    }

    public VersionIncEditOptions getVersionIncOptions(String lifecycleState, DocumentModel docModel) throws ClientException {
        if (null == lifecycleState) {
            throw new IllegalArgumentException("null lifecycleState ");
        }
        VersionIncEditOptions editOptions = new VersionIncEditOptions();
        for (EditBasedRuleDescriptor descriptor : this.editRuleDescriptors.values()) {
            String descriptorLifecycleState;
            if (!descriptor.isEnabled() || !descriptor.isDocTypeAccounted(docModel.getType()) || !(descriptorLifecycleState = descriptor.getLifecycleState()).equals("*") && !descriptorLifecycleState.equals(lifecycleState)) continue;
            editOptions.addInfo("Matching rule descriptor: " + descriptor);
            String action = descriptor.getAction();
            VersioningActions descriptorAction = VersioningActions.getByActionName((String)action);
            editOptions.addInfo("edit descriptor action: " + action + " => " + descriptorAction);
            if (VersioningActions.ACTION_CASE_DEPENDENT == descriptorAction) {
                RuleOptionDescriptor[] descOptions;
                for (RuleOptionDescriptor opt : descOptions = descriptor.getOptions()) {
                    VersioningActions vAction = VersioningActions.getByActionName((String)opt.getValue());
                    if (vAction != null) {
                        if (opt.isDefault()) {
                            editOptions.setDefaultVersioningAction(vAction);
                        }
                        editOptions.addOption(vAction);
                        continue;
                    }
                    log.warn((Object)("Invalid action name: " + opt));
                }
            }
            editOptions.setVersioningAction(descriptorAction);
            editOptions.addInfo("descriptorAction = " + descriptorAction);
            break;
        }
        log.debug((Object)("computed options: " + editOptions));
        return editOptions;
    }

    public void incrementVersions(VersionChangeRequest req) throws ClientException {
        if (req.getSource() == VersionChangeRequest.RequestSource.EDIT) {
            boolean handled;
            String docType;
            EditBasedRuleDescriptor descriptor;
            Iterator<EditBasedRuleDescriptor> i$ = this.editRuleDescriptors.values().iterator();
            while (!(!i$.hasNext() || (descriptor = i$.next()).isEnabled() && descriptor.isDocTypeAccounted(docType = req.getDocument().getType()) && (handled = this.performRuleAction(descriptor, req)))) {
            }
        } else if (req.getSource() == VersionChangeRequest.RequestSource.AUTO) {
            String lifecycleState;
            try {
                lifecycleState = req.getDocument().getCurrentLifeCycleState();
            }
            catch (ClientException e) {
                log.error((Object)e);
                log.warn((Object)("Cannot get CurrentLifeCycleState for document " + req.getDocument()));
                lifecycleState = "";
            }
            boolean handled = false;
            for (AutoBasedRuleDescriptor descriptor : this.autoRuleDescriptors.values()) {
                if (!descriptor.isEnabled()) continue;
                String descriptorLifecycleState = descriptor.getLifecycleState();
                if (descriptorLifecycleState == null) {
                    log.warn((Object)"descriptorLifecycleState is null, rule skipped");
                    continue;
                }
                if (!descriptorLifecycleState.equals("*") && !descriptorLifecycleState.equals(lifecycleState) || !(handled = this.performRuleAction(descriptor, req))) continue;
                break;
            }
            if (!handled) {
                VersioningActions action = req.getVersioningAction();
                if (action == null) {
                    log.warn((Object)"versioning action is null, inc version aborted.");
                    return;
                }
                this.performRuleAction(action, req.getDocument());
            }
        } else {
            log.warn((Object)("Not handled: " + req));
        }
    }

    private boolean performRuleAction(RuleDescriptor descriptor, VersionChangeRequest req) throws ClientException {
        String descActionName = descriptor.getAction();
        VersioningActions descAction = VersioningActions.getByActionName((String)descActionName);
        if (descAction == null) {
            log.error((Object)String.format("invalid action name: %s in descriptor: %s", descActionName, descriptor.getName()));
            return false;
        }
        VersioningActions action = descAction;
        if (action.equals((Object)VersioningActions.ACTION_CASE_DEPENDENT)) {
            action = req.getVersioningAction();
        }
        if (descriptor instanceof EditBasedRuleDescriptor) {
            String currentDocLifeCycleState;
            RuleOptionDescriptor[] opts = ((EditBasedRuleDescriptor)descriptor).getOptions();
            DocumentModel doc = req.getDocument();
            try {
                CoreSession coreSession = CoreInstance.getInstance().getSession(doc.getSessionId());
                if (null == coreSession) {
                    throw new ClientException("cannot get core session for doc: " + doc);
                }
                currentDocLifeCycleState = coreSession.getCurrentLifeCycleState(doc.getRef());
            }
            catch (ClientException e) {
                log.warn((Object)("cannot get lifecycle to perform possible transition specified by versioning in rule options " + descriptor.getName()), (Throwable)e);
                return false;
            }
            String descriptorLifecycleState = ((EditBasedRuleDescriptor)descriptor).getLifecycleState();
            if (!descriptorLifecycleState.equals("*") && !descriptorLifecycleState.equals(currentDocLifeCycleState)) {
                return false;
            }
            for (RuleOptionDescriptor option : opts) {
                String lsTrans;
                String optionValue = option.getValue();
                if (optionValue == null) {
                    log.error((Object)("RuleOptionDescriptor name not defined in RuleDescriptor: " + descriptor));
                    continue;
                }
                VersioningActions selectedOption = req.getVersioningAction();
                if (selectedOption == VersioningActions.ACTION_INCREMENT_DEFAULT && option.isDefault()) {
                    selectedOption = action = VersioningActions.getByActionName((String)optionValue);
                }
                if (selectedOption != VersioningActions.getByActionName((String)optionValue) || (lsTrans = option.getLifecycleTransition()) == null) continue;
                try {
                    doc.followTransition(lsTrans);
                }
                catch (ClientException e) {
                    throw new ClientException("cannot perform lifecycle transition: " + lsTrans + " specified by versioning rule:option " + descriptor.getName() + ":" + optionValue, e);
                }
            }
        }
        return this.performRuleAction(action, req.getDocument());
    }

    private boolean performRuleAction(VersioningActions action, DocumentModel doc) throws ClientException {
        if (action.equals((Object)VersioningActions.ACTION_INCREMENT_MAJOR)) {
            this.incrementMajor(doc);
        } else if (action.equals((Object)VersioningActions.ACTION_INCREMENT_MINOR)) {
            this.incrementMinor(doc);
        } else {
            log.debug((Object)("<incrementVersions> action not recognized: " + action));
            return false;
        }
        return true;
    }

    private static long getValidVersionNumber(DocumentModel doc, String propName) throws ClientException {
        Object propVal = doc.getProperty(DocumentModelUtils.getSchemaName((String)propName), DocumentModelUtils.getFieldName((String)propName));
        long ver = 0L;
        if (propVal != null) {
            try {
                ver = (Long)propVal;
            }
            catch (ClassCastException e) {
                throw new ClientException("Property " + propName + " should be of type Long");
            }
        }
        return ver;
    }

    public DocumentModel incrementMajor(DocumentModel document) throws ClientException {
        String docType = document.getType();
        String majorPropName = this.getMajorVersionPropertyName(docType);
        String minorPropName = this.getMinorVersionPropertyName(docType);
        long major = VersioningService.getValidVersionNumber(document, majorPropName) + 1L;
        long minor = 0L;
        document.setProperty(DocumentModelUtils.getSchemaName((String)majorPropName), DocumentModelUtils.getFieldName((String)majorPropName), (Object)major);
        document.setProperty(DocumentModelUtils.getSchemaName((String)minorPropName), DocumentModelUtils.getFieldName((String)minorPropName), (Object)minor);
        return document;
    }

    public DocumentModel incrementMinor(DocumentModel document) throws ClientException {
        String docType = document.getType();
        String majorPropName = this.getMajorVersionPropertyName(docType);
        String minorPropName = this.getMinorVersionPropertyName(docType);
        long major = VersioningService.getValidVersionNumber(document, majorPropName);
        long minor = VersioningService.getValidVersionNumber(document, minorPropName) + 1L;
        document.setProperty(DocumentModelUtils.getSchemaName((String)majorPropName), DocumentModelUtils.getFieldName((String)majorPropName), (Object)major);
        document.setProperty(DocumentModelUtils.getSchemaName((String)minorPropName), DocumentModelUtils.getFieldName((String)minorPropName), (Object)minor);
        return document;
    }

    public String getVersionLabel(DocumentModel document) throws ClientException {
        String documentType = document.getType();
        String majorPropName = this.getMajorVersionPropertyName(documentType);
        String minorPropName = this.getMinorVersionPropertyName(documentType);
        long major = VersioningService.getValidVersionNumber(document, majorPropName);
        long minor = VersioningService.getValidVersionNumber(document, minorPropName);
        return major + "." + minor;
    }

    public String getDefaultMajorVersionPropertyName() {
        return this.majorVersionProperty;
    }

    public String getDefaultMinorVersionPropertyName() {
        return this.minorVersionProperty;
    }

    public String getMajorVersionPropertyName(String documentType) {
        VersioningPropertiesDescriptor descriptor;
        String majorVersionField;
        if (this.propertiesDescriptors.containsKey(documentType) && (majorVersionField = (descriptor = this.propertiesDescriptors.get(documentType)).getMajorVersion()) != null) {
            return majorVersionField;
        }
        return this.majorVersionProperty;
    }

    public String getMinorVersionPropertyName(String documentType) {
        VersioningPropertiesDescriptor descriptor;
        String minorVersionField;
        if (this.propertiesDescriptors.containsKey(documentType) && (minorVersionField = (descriptor = this.propertiesDescriptors.get(documentType)).getMinorVersion()) != null) {
            return minorVersionField;
        }
        return this.minorVersionProperty;
    }

    public SnapshotOptions getCreateSnapshotOption(DocumentModel document) throws ClientException {
        if (null == document.getSessionId()) {
            throw new IllegalArgumentException("document model is not bound to a core session (null sessionId)");
        }
        CoreSession coreSession = CoreInstance.getInstance().getSession(document.getSessionId());
        if (coreSession == null) {
            throw new ClientException("cannot get core session for doc: " + document);
        }
        String lifecycleState = coreSession.getCurrentLifeCycleState(document.getRef());
        if (lifecycleState == null) {
            log.error((Object)("Cannot get lifecycle state for doc " + document));
            return SnapshotOptions.UNDEFINED;
        }
        for (CreateSnapshotDescriptor desc : this.snapshotDescriptors.values()) {
            if (!desc.applyForLifecycleState(lifecycleState)) continue;
            return desc.getSnapshotOption();
        }
        return SnapshotOptions.UNDEFINED;
    }
}

