/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.api.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutImpl
implements Layout {
    private static final long serialVersionUID = -8975637002024432963L;
    String id;
    final String name;
    final String mode;
    final String template;
    LayoutRow[] rows;
    final Map<String, Widget> widgetMap;
    final int columns;

    private LayoutImpl(String name, String mode, String template, int columns) {
        this.name = name;
        this.mode = mode;
        this.template = template;
        this.columns = columns;
        this.widgetMap = new HashMap<String, Widget>();
    }

    public LayoutImpl(String name, String mode, String template, List<LayoutRow> rows, int columns) {
        this(name, mode, template, columns);
        this.rows = rows.toArray(new LayoutRow[0]);
        this.computeWidgetMap();
    }

    protected void computeWidgetMap() {
        if (this.rows == null || this.rows.length == 0) {
            return;
        }
        for (LayoutRow row : this.rows) {
            Widget[] widgets = row.getWidgets();
            if (widgets == null || widgets.length == 0) continue;
            for (Widget widget : widgets) {
                if (widget == null) continue;
                this.widgetMap.put(widget.getName(), widget);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public String getTemplate() {
        return this.template;
    }

    @Override
    public LayoutRow[] getRows() {
        return this.rows;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public Widget getWidget(String name) {
        return this.widgetMap.get(name);
    }

    @Override
    public Map<String, Widget> getWidgetMap() {
        return Collections.unmodifiableMap(this.widgetMap);
    }
}

