/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.properties.FieldInfo;
import org.nuxeo.theme.vocabularies.VocabularyItem;

public class FieldProperty {
    private static final Log log = LogFactory.getLog(FieldProperty.class);
    private final String name;
    private final String value;
    private final FieldInfo info;

    public FieldProperty(String name, String value, FieldInfo info) {
        this.name = name;
        this.value = value;
        this.info = info;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getRendered() {
        StringBuilder rendered = new StringBuilder();
        String label = this.info.label();
        rendered.append("<label>").append(label);
        String description = this.info.description();
        if (!"".equals(description)) {
            rendered.append(String.format("<span class=\"description\">%s</span>", description));
        }
        rendered.append("</label>");
        String type = this.info.type();
        if ("text area".equals(type)) {
            rendered.append(String.format("<textarea name=\"%s\" class=\"fieldInput\">%s</textarea>", this.name, this.value));
        } else if ("string".equals(type) || "integer".equals(type)) {
            rendered.append(String.format("<input type=\"text\" class=\"textInput fieldInput\" name=\"%s\" value=\"%s\" />", this.name, this.value));
        } else if ("boolean".equals(type)) {
            if (Boolean.parseBoolean(this.value)) {
                rendered.append(String.format("<input type=\"checkbox\" class=\"fieldInput\" name=\"%s\" checked=\"checked\" />", this.name));
            } else {
                rendered.append(String.format("<input type=\"checkbox\" class=\"fieldInput\" name=\"%s\" />", this.name));
            }
        } else if ("selection".equals(type)) {
            List items;
            String source = this.info.source();
            if (!source.equals("") && (items = Manager.getVocabularyManager().getItems(source)) != null) {
                rendered.append(String.format("<select class=\"fieldInput\" name=\"%s\">", this.name));
                boolean found = false;
                for (VocabularyItem item : items) {
                    String itemValue = item.getValue();
                    if (itemValue.equals(this.value)) {
                        rendered.append(String.format("<option selected=\"selected\" value=\"%s\">%s</option>", itemValue, item.getLabel()));
                        found = true;
                        continue;
                    }
                    rendered.append(String.format("<option value=\"%s\">%s</option>", itemValue, item.getLabel()));
                }
                if (!found) {
                    rendered.append(String.format("<option>Invalid option: %s</option>", this.value));
                }
                rendered.append("</select>");
            }
        } else {
            log.error((Object)("Unknown field type: " + type));
        }
        if (this.info.required() && this.value.equals("")) {
            rendered.append("<span style=\"color: red\"> * </span>");
        }
        return rendered.toString();
    }
}

