/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.List;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.session.AbstractComponent;
import org.nuxeo.ecm.webengine.session.UserSession;
import org.nuxeo.theme.editor.ThemeInfo;
import org.nuxeo.theme.editor.UndoBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManager
extends AbstractComponent {
    private static final long serialVersionUID = 1L;
    private static final String SELECTED_ELEMENT_ID = "org.nuxeo.theme.editor.selected_element";
    private static final String STYLE_EDIT_MODE = "org.nuxeo.theme.editor.style_edit_mode";
    private static final String STYLE_LAYER_ID = "org.nuxeo.theme.editor.style_layer";
    private static final String NAMED_STYLE_ID = "org.nuxeo.theme.editor.named_style";
    private static final String STYLE_SELECTOR = "org.nuxeo.theme.editor.style_selector";
    private static final String STYLE_PROPERTY_CATEGORY = "org.nuxeo.theme.editor.style_property_category";
    private static final String STYLE_CATEGORY = "org.nuxeo.theme.editor.style_category";
    private static final String STYLE_MANAGER_MODE = "org.nuxeo.theme.editor.style_manager_mode";
    private static final String PRESET_MANAGER_MODE = "org.nuxeo.theme.editor.preset_manager_mode";
    private static final String PRESET_GROUP = "org.nuxeo.theme.editor.preset_group";
    private static final String PRESET_CATEGORY = "org.nuxeo.theme.editor.preset_category";
    private static final String CLIPBOARD_ELEMENT_ID = "org.nuxeo.theme.editor.clipboard_element";
    private static final String CLIPBOARD_PRESET_ID = "org.nuxeo.theme.editor.clipboard_preset";
    private static final String SELECTED_FRAGMENT_TYPE = "org.nuxeo.theme.editor.fragment_type";
    private static final String SELECTED_FRAGMENT_VIEW = "org.nuxeo.theme.editor.fragment_view";
    private static final String WORKSPACE_THEMES = "org.nuxeo.theme.editor.workspace_themes";
    private static final String UNDO_BUFFER = "org.nuxeo.theme.editor.undo_buffer";

    private static UserSession getUserSession() {
        return WebEngine.getActiveContext().getUserSession();
    }

    public static synchronized void setElementId(String id) {
        SessionManager.getUserSession().put((Object)SELECTED_ELEMENT_ID, (Object)id);
    }

    public static synchronized String getElementId() {
        return (String)SessionManager.getUserSession().get((Object)SELECTED_ELEMENT_ID);
    }

    public static synchronized String getStyleEditMode() {
        return (String)SessionManager.getUserSession().get((Object)STYLE_EDIT_MODE);
    }

    public static synchronized void setStyleEditMode(String mode) {
        SessionManager.getUserSession().put((Object)STYLE_EDIT_MODE, (Object)mode);
    }

    public static synchronized String getStyleLayerId() {
        return (String)SessionManager.getUserSession().get((Object)STYLE_LAYER_ID);
    }

    public static synchronized void setStyleLayerId(String id) {
        SessionManager.getUserSession().put((Object)STYLE_LAYER_ID, (Object)id);
    }

    public static synchronized String getNamedStyleId() {
        return (String)SessionManager.getUserSession().get((Object)NAMED_STYLE_ID);
    }

    public static synchronized void setNamedStyleId(String id) {
        SessionManager.getUserSession().put((Object)NAMED_STYLE_ID, (Object)id);
    }

    public static synchronized String getStyleSelector() {
        return (String)SessionManager.getUserSession().get((Object)STYLE_SELECTOR);
    }

    public static synchronized void setStyleSelector(String selector) {
        SessionManager.getUserSession().put((Object)STYLE_SELECTOR, (Object)selector);
    }

    public static synchronized String getStylePropertyCategory() {
        return (String)SessionManager.getUserSession().get((Object)STYLE_PROPERTY_CATEGORY);
    }

    public static synchronized void setStylePropertyCategory(String category) {
        SessionManager.getUserSession().put((Object)STYLE_PROPERTY_CATEGORY, (Object)category);
    }

    public static synchronized String getStyleCategory() {
        return (String)SessionManager.getUserSession().get((Object)STYLE_CATEGORY);
    }

    public static synchronized void setStyleCategory(String category) {
        SessionManager.getUserSession().put((Object)STYLE_CATEGORY, (Object)category);
    }

    public static synchronized String getStyleManagerMode() {
        return (String)SessionManager.getUserSession().get((Object)STYLE_MANAGER_MODE);
    }

    public static synchronized void setStyleManagerMode(String mode) {
        SessionManager.getUserSession().put((Object)STYLE_MANAGER_MODE, (Object)mode);
    }

    public static synchronized String getPresetManagerMode() {
        return (String)SessionManager.getUserSession().get((Object)PRESET_MANAGER_MODE);
    }

    public static synchronized void setPresetManagerMode(String mode) {
        SessionManager.getUserSession().put((Object)PRESET_MANAGER_MODE, (Object)mode);
    }

    public static synchronized String getPresetGroup() {
        return (String)SessionManager.getUserSession().get((Object)PRESET_GROUP);
    }

    public static synchronized void setPresetGroup(String group) {
        SessionManager.getUserSession().put((Object)PRESET_GROUP, (Object)group);
    }

    public static synchronized String getPresetCategory() {
        return (String)SessionManager.getUserSession().get((Object)PRESET_CATEGORY);
    }

    public static synchronized void setPresetCategory(String category) {
        SessionManager.getUserSession().put((Object)PRESET_CATEGORY, (Object)category);
    }

    public static synchronized String getClipboardElementId() {
        return (String)SessionManager.getUserSession().get((Object)CLIPBOARD_ELEMENT_ID);
    }

    public static synchronized void setClipboardElementId(String id) {
        SessionManager.getUserSession().put((Object)CLIPBOARD_ELEMENT_ID, (Object)id);
    }

    public static synchronized void setClipboardPresetId(String id) {
        SessionManager.getUserSession().put((Object)CLIPBOARD_PRESET_ID, (Object)id);
    }

    public static synchronized String getClipboardPresetId() {
        return (String)SessionManager.getUserSession().get((Object)CLIPBOARD_PRESET_ID);
    }

    public static synchronized void setFragmentType(String type) {
        SessionManager.getUserSession().put((Object)SELECTED_FRAGMENT_TYPE, (Object)type);
    }

    public static synchronized String getFragmentType() {
        return (String)SessionManager.getUserSession().get((Object)SELECTED_FRAGMENT_TYPE);
    }

    public static synchronized void setFragmentView(String view) {
        SessionManager.getUserSession().put((Object)SELECTED_FRAGMENT_VIEW, (Object)view);
    }

    public static synchronized String getFragmentView() {
        return (String)SessionManager.getUserSession().get((Object)SELECTED_FRAGMENT_VIEW);
    }

    public static synchronized List<ThemeInfo> getWorkspaceThemes() {
        return (List)SessionManager.getUserSession().get((Object)WORKSPACE_THEMES);
    }

    public static synchronized void setWorkspaceThemes(List<ThemeInfo> themes) {
        SessionManager.getUserSession().put((Object)WORKSPACE_THEMES, themes);
    }

    public static synchronized UndoBuffer getUndoBuffer(String themeName) {
        return (UndoBuffer)SessionManager.getUserSession().get((Object)String.format("%s.%s", UNDO_BUFFER, themeName));
    }

    public static synchronized void setUndoBuffer(String themeName, UndoBuffer undoBuffer) {
        SessionManager.getUserSession().put((Object)String.format("%s.%s", UNDO_BUFFER, themeName), (Object)undoBuffer);
    }
}

