/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.theme.themes.ThemeManager;

public class StyleFieldProperty {
    private final String name;
    private final String value;
    private final String type;
    private static final Pattern cssChoicePattern = Pattern.compile("\\[(.*?)\\]");

    public StyleFieldProperty(String name, String value, String type) {
        this.name = name;
        this.value = value.replace("\"", "&quot;");
        this.type = type;
    }

    public String getName() {
        return String.format("&quot;%s&quot;", this.name);
    }

    public String getValue() {
        return this.value;
    }

    public String getRendered() {
        StringBuilder rendered = new StringBuilder();
        String label = this.name;
        rendered.append("<label>").append(label).append("</label>");
        Matcher choiceMatcher = cssChoicePattern.matcher(this.type);
        boolean hasChoices = choiceMatcher.find();
        String category = ThemeManager.getPreviewCategoryForProperty((String)this.name);
        if (hasChoices) {
            String choices = choiceMatcher.group(1);
            rendered.append(String.format("<select name=\"property:%s\">", this.name));
            rendered.append("<option></option>");
            for (String choice : choices.split("\\|")) {
                rendered.append(String.format("<option%s>%s</option>", choice.equals(this.value) ? " selected=\"selected\"" : "", choice));
            }
            rendered.append("</select>");
        } else {
            String input = String.format("<input type=\"text\" class=\"textInput\" name=\"property:%s\" value=\"%s\" />", this.name, this.value);
            rendered.append(input);
        }
        if (category != null) {
            rendered.append(String.format("<input type=\"button\" class=\"picker\" property=\"%s\" category=\"%s\" value=\"\" />", this.name, category));
        }
        return rendered.toString();
    }
}

