/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.editor;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.theme.editor.FieldProperty;
import org.nuxeo.theme.elements.Element;
import org.nuxeo.theme.properties.FieldIO;
import org.nuxeo.theme.properties.FieldInfo;
import org.nuxeo.theme.themes.ThemeIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static List<FieldProperty> getPropertiesOf(Element element) {
        ArrayList<FieldProperty> fieldProperties = new ArrayList<FieldProperty>();
        if (element == null) {
            return fieldProperties;
        }
        Properties properties = new Properties();
        try {
            properties = FieldIO.dumpFieldsToProperties((Object)element);
        }
        catch (ThemeIOException e) {
            log.error((Object)("Failed to obtain properties of element: " + element.computeXPath()), (Throwable)e);
            return fieldProperties;
        }
        if (properties == null) {
            return fieldProperties;
        }
        Class<?> c = element.getClass();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = properties.getProperty(name);
            FieldInfo fieldInfo = FieldIO.getFieldInfo(c, (String)name);
            if (fieldInfo == null) continue;
            fieldProperties.add(new FieldProperty(name, value.trim(), fieldInfo));
        }
        return fieldProperties;
    }
}

